$(document).ready(function() {
	var trget = document.getElementById('modal-loader-inner');
	var modal_focus = craoul = edit_row = delete_row = "";
	var base = $(".site_base").text().trim();
	var flag = true;
	var opts = {
		 lines: 13 // The number of lines to draw
		, length: 0 // The length of each line
		, width: 14 // The line thickness
		, radius: 25 // The radius of the inner circle
		, scale: 1 // Scales overall size of the spinner
		, corners: 1 // Corner roundness (0..1)
		, color: '#fff' // #rgb or #rrggbb or array of colors
		, opacity: 0.25 // Opacity of the lines
		, rotate: 0 // The rotation offset
		, direction: 1 // 1: clockwise, -1: counterclockwise
		, speed: 1 // Rounds per second
		, trail: 60 // Afterglow percentage
		, fps: 20 // Frames per second when using setTimeout() as a fallback for CSS
		, zIndex: 2e9 // The z-index (defaults to 2000000000)
		, className: 'spinner' // The CSS class to assign to the spinner
		, top: '0' // Top position relative to parent
		, left: '50%' // Left position relative to parent
		, shadow: false // Whether to render a shadow
		, hwaccel: false // Whether to use hardware acceleration
		, position: 'absolute' // Element positioning
	};
	var spnr = new Spinner(opts).spin(trget);

	$(".sb-purchase-nav").addClass("active");

	$('.purchase-modal').on('shown.bs.modal', function (e) {
		modal_focus.focus();
	});

	function set_modal(title, form, focus, callback) {
		$.when($(".modal-loader-wrapper").hide())
		.then($(".purchase-modal span.input-error").remove())
		.then($(".purchase-modal form").hide())
		.then($(".purchase-modal form input[type='text']").val(""))
		.then($(".purchase-modal form #purchaseId").remove())
		.then($(".purchase-modal form textarea").val(""))
		.then($(".purchase-modal").find(".modal-title").text(title))
		.then($(".purchase-modal").find(form).show())
		.then(modal_focus = focus)
		.then(callback());
	}

	$(".purchase-add-nav").click(function() {

		set_modal("Add Purchase / Stock", "#add-purchase-form", $("#add-purchase-form #materialForm"), function() {
			$(".purchase-modal").modal("show");
		});
	});

	$("#add-purchase-form").submit(function() {

		if($("#add-purchase-form").valid() && flag) {

			flag = false;

			$(".modal-loader-wrapper").show();
			
			$.ajax({
				url: base + "patron/purchase/add",
				type: "post",
				data: $("#add-purchase-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					$(".list-no-record").remove();
					$(".purchase-table tbody").append("<tr><td>"+$("#add-purchase-form #materialForm").val().trim()+"</td><td class='text-center'>"+$("#add-purchase-form #materialType").val().trim()+"</td><td class='text-center'>"+$("#add-purchase-form #thickness").val().trim()+"</td><td class='text-center'>"+$("#add-purchase-form #width").val().trim()+"</td><td class='text-center'>"+$("#add-purchase-form #length").val().trim()+"</td><td class='text-center'>"+$("#add-purchase-form #qty").val().trim()+"</td><td class='text-center list-nav'><i class='fa fa-pencil text-primary edit-row' id='"+data.id+"'></i><i class='fa fa-times text-danger delete-row' id='"+data.id+"'></i></td></tr>");
					$(".purchase-modal form input[type='text']").val("");
				}

				clearTimeout(craoul);
				$("#add-purchase-form div.callout").remove();
				$("#add-purchase-form").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $("#add-purchase-form div.callout").remove() }, 4000);

				$("#add-purchase-form #materialForm").focus();
				$(".token").val(data.token_key);
				flag = true;
				$(".modal-loader-wrapper").hide();
			});
		}

		return false;
	});

	$("body").on("click", ".purchase-table tr td.list-nav .edit-row", function() {

		edit_row = $(this);

		set_modal("Edit Purchase / Stock", "#edit-purchase-form", $("#edit-purchase-form #materialForm"), function() {

			$("#edit-purchase-form #materialForm").val( edit_row.parents("tr").find("td:eq(0)").text().trim() );

			$("#edit-purchase-form #materialType").val( edit_row.parents("tr").find("td:eq(1)").text().trim() );

			$("#edit-purchase-form #thickness").val( edit_row.parents("tr").find("td:eq(2)").text().trim() );

			$("#edit-purchase-form #width").val( edit_row.parents("tr").find("td:eq(3)").text().trim() );

			$("#edit-purchase-form #length").val( edit_row.parents("tr").find("td:eq(4)").text().trim() );

			$("#edit-purchase-form #qty").val( edit_row.parents("tr").find("td:eq(5)").text().trim() );

			$("#edit-purchase-form").append("<input type='hidden' name='productId' id='purchaseId' value='"+edit_row.attr("id")+"' >");

			$(".purchase-modal").modal("show");
		});
	});

	$("#edit-purchase-form").submit(function() {

		if($("#edit-purchase-form").valid() && flag) {

			flag = false;

			$(".modal-loader-wrapper").show();
			
			$.ajax({
				url: base + "patron/purchase/edit",
				type: "post",
				data: $("#edit-purchase-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					
					edit_row.parents("tr").find("td:eq(0)").text( $("#edit-purchase-form #materialForm").val().trim() );

					edit_row.parents("tr").find("td:eq(1)").text( $("#edit-purchase-form #materialType").val().trim() );

					edit_row.parents("tr").find("td:eq(2)").text( $("#edit-purchase-form #thickness").val().trim() );

					edit_row.parents("tr").find("td:eq(3)").text( $("#edit-purchase-form #width").val().trim() );

					edit_row.parents("tr").find("td:eq(4)").text( $("#edit-purchase-form #length").val().trim() );

					edit_row.parents("tr").find("td:eq(5)").text( $("#edit-purchase-form #qty").val().trim() );

					$(".purchase-modal").modal("hide");

					clearTimeout(craoul);
					$(".box-parent-col div.callout").remove();
					$(".box-parent-col").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
					craoul = setTimeout(function(){ $(".box-parent-col div.callout").remove() }, 3000);
				}
				else {
					$("#edit-purchase-form").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
					$("#edit-purchase-form #materialForm").focus();
				}

				$(".token").val(data.token_key);
				flag = true;
				$(".modal-loader-wrapper").hide();
			});
		}

		return false;
	});

	$("body").on("click", ".purchase-table tr td.list-nav .delete-row", function() {

		if(flag) {

			flag = false;

			$(this).append("<img src='"+base + "assets/img/general/spinner_red.gif" + "' />");

			delete_row = $(this);

			$.ajax({
				url: base + "patron/purchase/delete",
				type: "get",
				data: { id: delete_row.attr("id")},
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {
				
				if(data.type == "success") {
					delete_row.parents("tr").remove();
				}

				if( $(".purchase-table tbody tr").length == 0 ) {
					$(".purchase-table tbody").append("<tr class='list-no-record'><td class='text-center text-info' colspan='7'><b>No Record Found</b></td></tr>");
				}

				clearTimeout(craoul);
				$(".box-parent-col div.callout").remove();
				$(".box-parent-col").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $(".box-parent-col div.callout").remove() }, 3000);
				
				flag = true;
			});
		}
	});
});