<div class="content-wrapper">
	<section class="content-header">
		<h1 class="content-header-text">
			<label>Party</label>
			<span class="btn btn-primary pull-right party-add-nav">Add</span>
		</h1>
	</section>

	<section class="content container-fluid">
		<div class="row">
			<div class="col-xs-12 box-parent-col">
				<div class="box box-primary">
					<div class="box-body table-responsive no-padding">
						<table class="table table-hover list-table party-table">
							<thead>
								<tr>
									<th>Name</th>
									<th class="text-center">Address</th>
									<th class="text-center">Account Name</th>
									<th class="text-center">Land Line</th>
									<th class="text-center">Mobile No.</th>
									<th class="text-center">Email</th>
									<th class="text-center">GST / CST No.</th>
									<th class="text-center">PAN No.</th>
									<th class="text-center">Reference</th>
									<th class="text-center">Remark</th>
									<th class="text-center">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if( $list->num_rows() > 0 ) {
										foreach ($list->result() as $row) {
											echo
											"<tr>
												<td>".$row->name."</td>
												<td class='text-center'>".$row->address."</td>
												<td class='text-center'>".$row->account_name."</td>
												<td class='text-center'>".$row->land_line."</td>
												<td class='text-center'>".$row->mobile."</td>
												<td class='text-center'>".$row->email."</td>
												<td class='text-center'>".$row->tax_no."</td>
												<td class='text-center'>".$row->pan_no."</td>
												<td class='text-center'>".$row->reference."</td>
												<td class='text-center'>".$row->remark."</td>
												<td class='text-center list-nav'>
													<i class='fa fa-bars party-requi-nav' id='".$row->id."'></i>
													<i class='fa fa-pencil text-primary edit-row' id='".$row->id."'></i>
													<i class='fa fa-times text-danger delete-row' id='".$row->id."'></i>
												</td>
											</tr>";
										}
									}
									else {
										echo
										"<tr class='list-no-record'>
											<td class='text-center text-info' colspan='11'><b>No Record Found</b></td>
										</tr>";
									}
								?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>

<div class="modal fade party-modal" id="party-modal" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-loader-wrapper dm-hide"><div class="modal-loader-inner" id="modal-loader-inner"></div></div>
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"></h4>
			</div>
			<div class="modal-body">
				<form id="add-party-form">
					<div class="form-group">
						<label for="partyName">Name</label>
						<input type="text" name="partyName" id="partyName" class="form-control" placeholder="Party Name">
					</div>

					<div class="form-group">
						<label for="address">address</label>
						<input type="text" name="address" id="address" class="form-control" placeholder="Party Address">
					</div>

					<div class="form-group">
						<label for="accountName">Account Name</label>
						<input type="text" name="accountName" id="accountName" class="form-control" placeholder="Account Name">
					</div>

					<div class="form-group">
						<label for="landLine">Land Line</label>
						<input type="text" name="landLine" id="landLine" class="form-control" placeholder="Land Line">
					</div>

					<div class="form-group">
						<label for="mobile">Mobile</label>
						<input type="text" name="mobile" id="mobile" class="form-control" placeholder="Mobile">
					</div>

					<div class="form-group">
						<label for="email">Email</label>
						<input type="text" name="email" id="email" class="form-control" placeholder="Email">
					</div>

					<div class="form-group">
						<label for="taxNo">GST / CST No.</label>
						<input type="text" name="taxNo" id="taxNo" class="form-control" placeholder="GST / CST No.">
					</div>

					<div class="form-group">
						<label for="panNo">PAN No.</label>
						<input type="text" name="panNo" id="panNo" class="form-control" placeholder="PAN No.">
					</div>

					<div class="form-group">
						<label for="reference">Reference</label>
						<input type="text" name="reference" id="reference" class="form-control" placeholder="Reference">
					</div>

					<div class="form-group">
						<label for="remark">Remark</label>
						<textarea name="remark" id="remark" class="form-control" placeholder="Remark"></textarea>
					</div>

					<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">

					<div class="form-group text-right form-nav">
						<button type="submit" class="btn btn-primary">Save</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>

				<form id="edit-party-form">
					<div class="form-group">
						<label for="partyName">Name</label>
						<input type="text" name="partyName" id="partyName" class="form-control" placeholder="Party Name">
					</div>

					<div class="form-group">
						<label for="address">address</label>
						<input type="text" name="address" id="address" class="form-control" placeholder="Party Address">
					</div>

					<div class="form-group">
						<label for="accountName">Account Name</label>
						<input type="text" name="accountName" id="accountName" class="form-control" placeholder="Account Name">
					</div>

					<div class="form-group">
						<label for="landLine">Land Line</label>
						<input type="text" name="landLine" id="landLine" class="form-control" placeholder="Land Line">
					</div>

					<div class="form-group">
						<label for="mobile">Mobile</label>
						<input type="text" name="mobile" id="mobile" class="form-control" placeholder="Mobile">
					</div>

					<div class="form-group">
						<label for="email">Email</label>
						<input type="text" name="email" id="email" class="form-control" placeholder="Email">
					</div>

					<div class="form-group">
						<label for="taxNo">GST / CST No.</label>
						<input type="text" name="taxNo" id="taxNo" class="form-control" placeholder="GST / CST No.">
					</div>

					<div class="form-group">
						<label for="panNo">PAN No.</label>
						<input type="text" name="panNo" id="panNo" class="form-control" placeholder="PAN No.">
					</div>

					<div class="form-group">
						<label for="reference">Reference</label>
						<input type="text" name="reference" id="reference" class="form-control" placeholder="Reference">
					</div>

					<div class="form-group">
						<label for="remark">Remark</label>
						<textarea name="remark" id="remark" class="form-control" placeholder="Remark"></textarea>
					</div>

					<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">

					<div class="form-group text-right form-nav">
						<button type="submit" class="btn btn-primary">Save</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<div class="modal fade party-requirement-modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-loader-wrapper party-requ-mlw dm-hide"><div class="modal-loader-inner" id="requ-modal-loader-inner"></div></div>
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">×</span>
				</button>
				<h4 class="modal-title" id="myLargeModalLabel">Party Requirement</h4>
			</div>
			<div class="modal-body">
				<form id="add-party-requirement-form">
					<div class="row">
						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="form-group">
								<label for="materialForm">Material Form</label>
								<input type="text" name="materialForm" id="materialForm" class="form-control" placeholder="Material Form">
							</div>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="form-group">
								<label for="materialType">Material Type</label>
								<input type="text" name="materialType" id="materialType" class="form-control" placeholder="Material Type">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-3 col-xs-12">
							<div class="form-group">
								<label for="thickness">Thickness</label>
								<input type="text" name="thickness" id="thickness" class="form-control" placeholder="Thickness">
							</div>
						</div>

						<div class="col-lg-2 col-md-2 col-sm-3 col-xs-12">
							<div class="form-group">
								<label for="width">Width (MM)</label>
								<input type="text" name="width" id="width" class="form-control" placeholder="Width">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-3 col-xs-12">
							<div class="form-group">
								<label for="length">Length (MM)</label>
								<input type="text" name="length" id="length" class="form-control" placeholder="Length">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-3 col-xs-12">
							<div class="form-group">
								<label for="qty">QTY</label>
								<input type="text" name="qty" id="qty" class="form-control" placeholder="QTY">
							</div>
						</div>

						<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
							<div class="form-group" style="padding-top: 25px;">
								<button type="submit" class="btn btn-primary" style="margin-right: 5px;">Save</button>
								<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							</div>
						</div>

						<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">
					</div>
				</form>
				<form id="edit-party-requirement-form">
					<div class="row">
						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="form-group">
								<label for="materialForm">Material Form</label>
								<input type="text" name="materialForm" id="materialForm" class="form-control" placeholder="Material Form">
							</div>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="form-group">
								<label for="materialType">Material Type</label>
								<input type="text" name="materialType" id="materialType" class="form-control" placeholder="Material Type">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
							<div class="form-group">
								<label for="thickness">Thickness</label>
								<input type="text" name="thickness" id="thickness" class="form-control" placeholder="Thickness">
							</div>
						</div>

						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
							<div class="form-group">
								<label for="width">Width (MM)</label>
								<input type="text" name="width" id="width" class="form-control" placeholder="Width">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
							<div class="form-group">
								<label for="length">Length (MM)</label>
								<input type="text" name="length" id="length" class="form-control" placeholder="Length">
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
							<div class="form-group">
								<label for="qty">QTY</label>
								<input type="text" name="qty" id="qty" class="form-control" placeholder="QTY">
							</div>
						</div>

						<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
							<div class="form-group" style="padding-top: 25px;">								
								<button type="submit" class="btn btn-primary" style="margin-right: 5px;">Save</button>
								<button type="button" class="btn btn-info close-party-edit" style="margin-right: 5px;">Cancle</button>
								<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							</div>
						</div>

						<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">
					</div>
				</form>

				<h3 style="font-size: 18px;border-bottom: 1px solid #d4d4d4;margin: 10px 0;padding-bottom: 5px;">List</h3>

				<div class="table-responsive no-padding">
					<table class="table table-hover list-table party-requirement-table">
						<thead>
							<tr>
								<th>Material Form</th>
								<th class="text-center">Material Type</th>
								<th class="text-center">Thickness</th>
								<th class="text-center">Width (MM)</th>
								<th class="text-center">Length (MM)</th>
								<th class="text-center">QTY</th>
								<th class="text-center">Action</th>
							</tr>
						</thead>
						<tbody>
							<tr class="loader_tr">
								<td colspan="7" class="text-center" style="padding: 35px 0 0 0">
									<img src="<?php echo base_url('assets/img/general/spinner_orange.gif'); ?>" />
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript" src="<?php echo base_url('assets/js/admin/party.js') ?>"></script>