<?php

class PurchaseModel extends CI_Model {

	public function checkPurchase($post) {

		$check_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"]
		);

		return $this->db->get_where("purchase", $check_data);
	}

	public function setPurchase($post) {

		$add_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->insert("purchase", $add_data);
	}

	public function getPurchaseMaxId($post) {

		return $this->db

		->select_max("id")

		->where(array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		))

		->get("purchase");
	}

	public function getAllPurchase() {

		return $this->db->get("purchase");
	}

	public function checkPurchaseForEdit($post) {

		$check_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"id !=" => $post["productId"]
		);

		return $this->db->get_where("purchase", $check_data);
	}

	public function editPurchase($post) {

		$edit_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->update("purchase", $edit_data, array("id" => $post["productId"]));
	}

	public function deletePurchase($id) {

		return $this->db->delete('purchase', array('id' => $id));
	}
}