<?php

class PartyRequModel extends CI_Model {

	public function checkRequirement($post) {

		$check_data = array (
			"party_id" => $post["partyId"],
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->get_where("party_requirement", $check_data);
	}

	public function setRequirement($post) {

		$add_data = array (
			"party_id" => $post["partyId"],
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->insert("party_requirement", $add_data);
	}

	public function getRequirementMaxId($post) {

		return $this->db

		->select_max("id")

		->where(array (
			"party_id" => $post["partyId"],
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		))

		->get("party_requirement");
	}

	public function getRequirement($party_id) {

		return $this->db->get_where("party_requirement", array("party_id" => $party_id));
	}

	public function checkRequirementForEdit($post) {

		$check_data = array (
			"party_id" => $post["partyId"],
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"],
			"id !=" => $post["requirementId"]
		);

		return $this->db->get_where("party_requirement", $check_data);
	}

	public function editRequirement($post) {

		$edit_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->update("party_requirement", $edit_data, array("id" => $post["requirementId"]));
	}

	public function deleteRequirement($id) {

		return $this->db->delete("party_requirement", array('id' => $id));
	}
}