<?php

class PartyModel extends CI_Model {

	public function setParty($post) {

		$add_data = array (
			"name" => trim($post["partyName"]),
			"address" => trim($post["address"]),
			"account_name" => trim($post["accountName"]),
			"land_line" => trim($post["landLine"]),
			"mobile" => trim($post["mobile"]),
			"email" => trim($post["email"]),
			"tax_no" => trim($post["taxNo"]),
			"pan_no" => trim($post["panNo"]),
			"reference" => trim($post["reference"]),
			"remark" => trim($post["remark"]),
		);

		return $this->db->insert("party", $add_data);
	}

	public function getPartyMaxId($post) {

		return $this->db

		->select_max("id")

		->where(array (
			"name" => trim($post["partyName"]),
			"address" => trim($post["address"]),
			"account_name" => trim($post["accountName"]),
			"land_line" => trim($post["landLine"]),
			"mobile" => trim($post["mobile"]),
			"email" => trim($post["email"]),
			"tax_no" => trim($post["taxNo"]),
			"pan_no" => trim($post["panNo"]),
			"reference" => trim($post["reference"]),
			"remark" => trim($post["remark"]),
		))

		->get("party");
	}

	public function getAllParty() {

		return $this->db->get("party");
	}

	public function checkPurchaseForEdit($post) {

		$check_data = array (
			"name" => trim($post["partyName"]),
			"address" => trim($post["address"]),
			"account_name" => trim($post["accountName"]),
			"land_line" => trim($post["landLine"]),
			"mobile" => trim($post["mobile"]),
			"email" => trim($post["email"]),
			"tax_no" => trim($post["taxNo"]),
			"pan_no" => trim($post["panNo"]),
			"id !=" => $post["partyId"]
		);

		return $this->db->get_where("party", $check_data);
	}

	public function editParty($post) {

		$edit_data = array (
			"name" => trim($post["partyName"]),
			"address" => trim($post["address"]),
			"account_name" => trim($post["accountName"]),
			"land_line" => trim($post["landLine"]),
			"mobile" => trim($post["mobile"]),
			"email" => trim($post["email"]),
			"tax_no" => trim($post["taxNo"]),
			"pan_no" => trim($post["panNo"]),
			"reference" => trim($post["reference"]),
			"remark" => trim($post["remark"]),
		);

		return $this->db->update("party", $edit_data, array("id" => $post["partyId"]));
	}

	public function deleteParty($id) {

		return $this->db->delete("party", array('id' => $id));
	}
}