<?php

class BeforeFilter {

	private $ci;

	function __construct() {
		date_default_timezone_set('Asia/Kolkata');
		$this->ci =& get_instance();
	}

	private $leave_out_routes = array (
		'route_1' => array (
			'class' => 'TestController',
			'method' => 'index'
		),
		'route_2' => array (
			'class' => 'UserController',
			'method' => 'getLockView'
		),
		'route_3' => array (
			'class' => 'UserController',
			'method' => 'getLockAuth'
		),
		'route_4' => array (
			'class' => 'UserController',
			'method' => 'out'
		),
	);

	private $classes = array (
		"usercontroller"
	);

	public function apply_before_filter() {

		if ( in_array( strtolower( $this->ci->uri->segment(1) ), $this->classes ) ) {

			$data["heading"] = "404 Page Not Found";

			$data["message"] = "<p>The page you requested was not found.</p>";

			return $this->ci->load->view("errors/html/error_404", $data);
		}

		$key = array_keys($this->leave_out_routes, array("class" => $this->ci->router->class, "method" => $this->ci->router->method));

		if( strtolower($this->ci->uri->segment(1)) == "patron" && empty($key) && ! isset($this->ci->session->user) ) {

			redirect(base_url('out'));
		}
	}
}

?>