<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class UserController extends CI_Controller {

	public function getLockView() {

		if( isset( $this->session->user ) ) {

			redirect(base_url("patron/party"));
		}

		$data["token_name"] = $this->security->get_csrf_token_name();

		$data["token_key"] = $this->security->get_csrf_hash();
		
		$this->load->view("patron/pages/lock", $data);
	}

	public function getLockAuth() {
		
		if( $this->input->is_ajax_request() ) {

			$this->load->model("UserModel");

			$row =  $this->UserModel->getLockAuth($this->input->post("userPass"));

			if( $row->num_rows() == 1 && $row->row()->status == 1 ) {

				$this->session->set_userdata("user",
					array (
						"id"			=> $row->row()->id,
						"first_name"	=> $row->row()->first_name,
						"last_name"		=> $row->row()->last_name,
						"user_name"		=> $row->row()->user_name,
						"email"			=> $row->row()->email,
						"status"		=> $row->row()->status,
					)
				);

				$data["status"] = true;
			}
			else {
				$data["token"] = $this->security->get_csrf_hash();
				$data["status"] = false;
			}

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function out() {

		$this->session->sess_destroy();

		redirect(base_url("lock/auth"));
	}
}