<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PartyRequController extends CI_Controller {

	public function fetchRequirement() {

		$this->load->model("PartyRequModel");

		$data["list"] = $this->PartyRequModel->getRequirement($this->input->get("party_id"))->result();

		echo json_encode($data);
	}

	public function addRequirement() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyRequModel");

			$check = $this->PartyRequModel->checkRequirement($this->input->post());

			if( $check->num_rows() >= 1 ) {

				$data = array ( "type" => "danger", "message" => "This requirement allready added." );
			}
			else {

				$add = $this->PartyRequModel->setRequirement($this->input->post());

				if($add) {

					$id = $this->PartyRequModel->getRequirementMaxId($this->input->post())->row()->id;

					$data = array ( "type" => "success", "message" => "Requirement added successfully.", "id" => $id);
				}
				else {

					$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
				}
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function editRequirement() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyRequModel");

			$check = $this->PartyRequModel->checkRequirementForEdit($this->input->post());

			if( $check->num_rows() >= 1 ) {

				$data = array ( "type" => "danger", "message" => "Requirement with this data alredy existed." );
			}
			else {

				$edit = $this->PartyRequModel->editRequirement($this->input->post());

				if($edit) {

					$data = array ( "type" => "success", "message" => "Requirement edited successfully.");
				}
				else {

					$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
				}
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function deleteRequirement() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyRequModel");

			$delete = $this->PartyRequModel->deleteRequirement($this->input->get("id"));

			if($delete) {

				$data = array ( "type" => "success", "message" => "Requirement deleted successfully.");
			}
			else {

				$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}
}