<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PartyController extends CI_Controller {

	public function index() {

		$this->load->model("PartyModel");

		$data["list"] = $this->PartyModel->getAllParty();

		$data["token_name"] = $this->security->get_csrf_token_name();

		$data["token_key"] = $this->security->get_csrf_hash();

		$data["page"] = "party";

		$this->load->view("patron/layout/wrapper", $data);
	}

	public function addParty() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyModel");

			$add = $this->PartyModel->setParty($this->input->post());

			if($add) {

				$id = $this->PartyModel->getPartyMaxId($this->input->post())->row()->id;

				$data = array ( "type" => "success", "message" => "Party added successfully.", "id" => $id);
			}
			else {

				$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function editParty() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyModel");

			$check = $this->PartyModel->checkPurchaseForEdit($this->input->post());

			if( $check->num_rows() >= 1 ) {

				$data = array ( "type" => "danger", "message" => "Party with this data alredy existed." );
			}
			else {

				$edit = $this->PartyModel->editParty($this->input->post());

				if($edit) {

					$data = array ( "type" => "success", "message" => "Party edited successfully.");
				}
				else {

					$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
				}
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function deleteParty() {

		if( $this->input->is_ajax_request() ) {

			$this->load->model("PartyModel");

			$delete = $this->PartyModel->deleteParty($this->input->get("id"));

			if($delete) {

				$data = array ( "type" => "success", "message" => "Party deleted successfully.");
			}
			else {

				$data = array ( "type" => "danger", "message" => "Somthing went wrong. Try after sometime." );
			}

			$data["token_key"] = $this->security->get_csrf_hash();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}
}