<div class="app-container">
	<form id="billForm">
		<div class="row row-0" style="margin-bottom: 30px;">
			<label class="lbl">Party Name : </label>
			<input type="text" name="partyName" autofocus />
		</div>

		<div class="row row-1">
			<div class="col col-1">
				<label class="lbl">RSL NO : </label>
				<input type="text" name="rslNumber" />
			</div>
			<div class="col">&nbsp;</div>
			<div class="col col-2">
				<label class="lbl">Vehicle No : </label>
				<input type="text" name="vNumber" />
			</div>
		</div>
		<div class="row row-2">
			<div class="col col-1">
				<label class="lbl">Gross : </label>
				<input type="text" name="gross" />
			</div>
			<div class="col col-2">
				<label class="lbl">KG. DATE : </label>
				<input type="text" name="date1" value="<?php echo date("d/m/Y");?>">
			</div>
			<div class="col col-3">
				<label class="lbl">TIME : </label>
				<input type="text" name="time1" value="<?php echo date("h:i a");?>">
			</div>
		</div>
		<div class="row row-2">
			<div class="col col-1">
				<label class="lbl">TARE : </label>
				<input type="text" name="tare" />
			</div>
			<div class="col col-2">
				<label class="lbl">KG. DATE : </label>
				<input type="text" name="date2" value="<?php echo date("d/m/Y");?>">
			</div>
			<div class="col col-3">
				<label class="lbl">TIME : </label>
				<input type="text" name="time2" value="<?php echo date("h:i a");?>">
			</div>
		</div>
		<div class="row row-2">
			<div class="col col-1">
				<label class="lbl">NETT : </label>
				<input type="text" name="nett" />
			</div>
		</div>
		<div class="row row-3" style="text-align: center; margin-top: 50px; margin-bottom: 50px;">
			<div class="cd-spinner-wrapper text-center app-loader app-hide">
				<svg class="cd-spinner-svg" viewBox="25 25 50 50">
					<circle stroke="#007bff" class="cd-spinner-circle" cx="50" cy="50" r="20" fill="none" stroke-width="5" stroke-miterlimit="10"></circle>
				</svg>
			</div>
			<button type="button" class="print-btn" id="saveDataBtn">Save</button>
			<button type="button" class="print-btn" id="pritAgainBtn" disabled>Print Again</button>
			<button type="button" class="print-btn" id="clearForm">Clear Form</button>
		</div>
	</form>
	<iframe class="print_iframe1" id="print_iframe1" name="print_iframe1"></iframe>
</div>

<div class="print-container">
	<table class="bill-list-tbl">
		<thead>
			<tr>
				<th>Party</th>
				<th>RSL NO</th>
				<th>Vehicle No</th>
				<th>Gross</th>
				<th>KG. DATE 1</th>
				<th>TIME 1</th>
				<th>TARE</th>
				<th>KG. DATE 2</th>
				<th>TIME 2</th>
				<th>NETT</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($bills as $row) { ?>
			<tr>
				<td><?php echo $row->bill_party; ?></td>
				<td><?php echo $row->bill_rsl_no; ?></td>
				<td><?php echo $row->bill_vehicle_no; ?></td>
				<td><?php echo $row->bill_gross; ?></td>
				<td><?php echo $row->bill_kg_date1; ?></td>
				<td><?php echo $row->bill_time1; ?></td>
				<td><?php echo $row->bill_tare; ?></td>
				<td><?php echo $row->bill_kg_date2; ?></td>
				<td><?php echo $row->bill_time2; ?></td>
				<td><?php echo $row->bill_nett; ?></td>
			</tr>
			<?php } ?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
	function getPrint() {
		document.getElementById('print_iframe1').contentWindow.print();
	}

	function setPrintContainer() {
		var party = (document.getElementsByName("partyName")[0].value.trim() != "") ? document.getElementsByName("partyName")[0].value.trim() : "-";
		var rslNumber = (document.getElementsByName("rslNumber")[0].value.trim() != "") ? document.getElementsByName("rslNumber")[0].value.trim() : "-";
		var vNumber = (document.getElementsByName("vNumber")[0].value.trim() != "") ? document.getElementsByName("vNumber")[0].value.trim() : "-";
		var gross = (document.getElementsByName("gross")[0].value.trim() != "") ? document.getElementsByName("gross")[0].value.trim() : "-";
		var date1 = (document.getElementsByName("date1")[0].value.trim() != "") ? document.getElementsByName("date1")[0].value.trim() : "-";
		var time1 = (document.getElementsByName("time1")[0].value.trim() != "") ? document.getElementsByName("time1")[0].value.trim() : "-";
		var tare = (document.getElementsByName("tare")[0].value.trim() != "") ? document.getElementsByName("tare")[0].value.trim() : "-";
		var date2 = (document.getElementsByName("date2")[0].value.trim() != "") ? document.getElementsByName("date2")[0].value.trim() : "-";
		var time2 = (document.getElementsByName("time2")[0].value.trim() != "") ? document.getElementsByName("time2")[0].value.trim() : "-";
		var nett = (document.getElementsByName("nett")[0].value.trim() != "") ? document.getElementsByName("nett")[0].value.trim() : "-";
		
		iframe_html = "<!DOCTYPE html><html><head><title></title><link rel='stylesheet' type='text/css' href='<?php echo base_url("assets/css/print.css"); ?>' /></head><body>";

		iframe_html += "<div class='printWrapper' id='printWrapper'>";

		iframe_html += "<div class='row row-1'>";
		iframe_html += "<label class='print-lbl rslNumber_lbl'>"+rslNumber+"</label>";
		iframe_html += "<label class='print-lbl vNumber_lbl'>"+vNumber+"</label>";
		iframe_html += "</div>";

		iframe_html += "<div class='row row-2'>";
		iframe_html += "<label class='print-lbl gross_lbl'>"+gross+"</label>";
		iframe_html += "<label class='print-lbl date1_lbl'>"+date1+"</label>";
		iframe_html += "<label class='print-lbl time1_lbl'>"+time1+"</label>";
		iframe_html += "</div>";

		iframe_html += "<div class='row row-3'>";
		iframe_html += "<label class='print-lbl tare_lbl'>"+tare+"</label>";
		iframe_html += "<label class='print-lbl date2_lbl'>"+date2+"</label>";
		iframe_html += "<label class='print-lbl time2_lbl'>"+time2+"</label>";
		iframe_html += "</div>";

		iframe_html += "<div class='row row-4'>";
		iframe_html += "<label class='print-lbl nett_lbl'>"+nett+"</label>";
		iframe_html += "</div>";

		iframe_html += "</div>"; // .printWrapper over
		iframe_html += "</body></html>";

		var iframe = document.getElementById("print_iframe1"),
		frameDoc = iframe.contentDocument || iframe.contentWindow.document;
		frameDoc.innerHTML = "";
		frameDoc.open();
		frameDoc.write(iframe_html);
		frameDoc.close();

		$.ajax({
			url: "bill/save",
			type: "post",
			data: $("#billForm").serialize(),
			dataType: "json"
		})
		.done(function(data) {
			$(".bill-list-tbl tbody").prepend("<tr><td>"+party+"</td><td>"+rslNumber+"</td><td>"+vNumber+"</td><td>"+gross+"</td><td>"+date1+"</td><td>"+time1+"</td><td>"+tare+"</td><td>"+date2+"</td><td>"+time2+"</td><td>"+nett+"</td></tr>");
			$(".app-loader").addClass("app-hide");
			$("#saveDataBtn").prop("disabled", true);
			$("#pritAgainBtn").prop("disabled", false);
			getPrint();
		});
	}

	$(document).ready(function() {
		$("#saveDataBtn").click(function() {
			$(".app-loader").removeClass("app-hide");
			setPrintContainer();
		});

		$("#clearForm").click(function() {
			document.getElementsByName("partyName")[0].value = "";
			document.getElementsByName("rslNumber")[0].value = "";
			document.getElementsByName("vNumber")[0].value = "";
			document.getElementsByName("gross")[0].value = "";
			document.getElementsByName("tare")[0].value = "";
			document.getElementsByName("nett")[0].value = "";
			document.getElementsByName("partyName")[0].focus();
			$("#saveDataBtn").prop("disabled", false);
			$("#pritAgainBtn").prop("disabled", true);
		});

		$("#pritAgainBtn").click(function() {
			getPrint();
		});
	});
</script>