$(document).ready(function() {

	$.validator.setDefaults({
		ignore: [],
		errorElement: "span",
		errorClass: "input-error",
		validClass: "has-success",
		errorPlacement: function(error, element) {

			if (element.attr("type") == "radio") {

				error.appendTo(element.parents(".rgroup"));

				/*error.insertBefore(element);*/
			}
			else {
				error.insertAfter(element);
			}
		}
	});

	/*--------------------------------------
		Purchase - Add
	--------------------------------------*/
	$("#add-purchase-form").validate({
		onfocusout: false,
		rules: {
			materialForm: {
				required: true,
			},
			materialType: {
				required: true,
			},
			serial_no: {
				required: true,
				number: true
			},
			thickness: {
				required: true,
				number: true,
			},
			width: {
				number: true,
			},
			length: {
				number: true,
			},
			qty: {
				required: true,
				number: true,
			},
		},
		messages: {
			materialForm:{
				required: "Enter Material Form",
			},
			materialType: {
				required: "Enter Material Type",
			},
			serial_no: {
				required: "Enter Serial Number",
				number: "Enter Only Number ",
			},
			thickness: {
				required: "Enter Thickness",
				number: "Enter Only Number ",
			},
			width: {
				number: "Enter Only Number ",
			},
			length: {
				number: "Enter Only Number ",
			},
			qty: {
				required: "Enter qty",
				number: "Enter Only Number ",
			},
		},
	});
	/*--------------------------------------
		Purchase - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Purchase - Edit
	--------------------------------------*/
	$("#edit-purchase-form").validate({
		onfocusout: false,
		rules: {
			materialForm: {
				required: true,
			},
			materialType: {
				required: true,
			},
			serial_no: {
				required: true,
				number: true
			},
			thickness: {
				required: true,
				number: true,
			},
			width: {
				number: true,
			},
			length: {
				number: true,
			},
			qty: {
				required: true,
				number: true,
			},
		},
		messages: {
			materialForm:{
				required: "Enter Material Form",
			},
			materialType: {
				required: "Enter Material Type",
			},
			serial_no: {
				required: "Enter Serial Number",
				number: "Enter Only Number ",
			},
			thickness: {
				required: "Enter Thickness",
				number: "Enter Only Number ",
			},
			width: {
				number: "Enter Only Number ",
			},
			length: {
				number: "Enter Only Number ",
			},
			qty: {
				required: "Enter qty",
				number: "Enter Only Number ",
			},
		},
	});
	/*--------------------------------------
		Purchase - Edit Over
	--------------------------------------*/


	/*--------------------------------------
		Party - Add
	--------------------------------------*/
	$("#add-party-form").validate({
		onfocusout: false,
		rules: {
			partyName: {
				required: true,
			},
			address: {
				required: true,
			},
			accountName: {
				required: true
			},
			landLine: {
				required: true
			},
			mobile: {
				required: true
			},
			email: {
				required: true,
				email: true,
			},
			taxNo: {
				required: true
			},
			panNo: {
				required: true
			},
			reference: {
				required: true
			},
			remark: {
				required: true
			},
		},
		messages: {
			partyName: {
				required: "Enter Party Name",
			},
			address: {
				required: "Enter Address",
			},
			accountName: {
				required: "Enter Account Name",
			},
			landLine: {
				required: "Enter Land Line",
			},
			mobile: {
				required: "Enter Mobile",
			},
			email: {
				required: "Enter Email",
				email: "Invalid Email",
			},
			taxNo: {
				required: "Enter CST /GST No.",
			},
			panNo: {
				required: "Enter PAN No.",
			},
			reference: {
				required: "Enter Reference",
			},
			remark: {
				required: "Enter Remark",
			},
		},
	});
	/*--------------------------------------
		Party - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Party - Edit
	--------------------------------------*/
	$("#edit-party-form").validate({
		onfocusout: false,
		rules: {
			partyName: {
				required: true,
			},
			address: {
				required: true,
			},
			accountName: {
				required: true
			},
			landLine: {
				required: true
			},
			mobile: {
				required: true
			},
			email: {
				required: true,
				email: true,
			},
			taxNo: {
				required: true
			},
			panNo: {
				required: true
			},
			reference: {
				required: true
			},
			remark: {
				required: true
			},
		},
		messages: {
			partyName: {
				required: "Enter Party Name",
			},
			address: {
				required: "Enter Address",
			},
			accountName: {
				required: "Enter Account Name",
			},
			landLine: {
				required: "Enter Land Line",
			},
			mobile: {
				required: "Enter Mobile",
			},
			email: {
				required: "Enter Email",
				email: "Invalid Email",
			},
			taxNo: {
				required: "Enter CST /GST No.",
			},
			panNo: {
				required: "Enter PAN No.",
			},
			reference: {
				required: "Enter Reference",
			},
			remark: {
				required: "Enter Remark",
			},
		},
	});
	/*--------------------------------------
		Party - Edit Over
	--------------------------------------*/


	/*--------------------------------------
		Party Requirement - Add
	--------------------------------------*/
	$("#add-party-requirement-form").validate({
		onfocusout: false,
		rules: {
			materialForm: {
				required: true,
			},
			materialType: {
				required: true,
			},
			thickness: {
				required: true,
				number: true,
			},
			width: {
				required: true,
				number: true,
			},
			length: {
				required: true,
				number: true,
			},
			qty: {
				required: true,
				number: true,
			},
		},
		messages: {
			materialForm:{
				required: "Enter Material Form",
			},
			materialType: {
				required: "Enter Material Type",
			},
			thickness: {
				required: "Enter Thickness",
				number: "Enter Only Number ",
			},
			width: {
				required: "Enter Width",
				number: "Enter Only Number ",
			},
			length: {
				required: "Enter Length",
				number: "Enter Only Number ",
			},
			qty: {
				required: "Enter qty",
				number: "Enter Only Number ",
			},
		},
	});
	/*--------------------------------------
		Party Requirement - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Party Requirement - Add
	--------------------------------------*/
	$("#edit-party-requirement-form").validate({
		onfocusout: false,
		rules: {
			materialForm: {
				required: true,
			},
			materialType: {
				required: true,
			},
			thickness: {
				required: true,
				number: true,
			},
			width: {
				required: true,
				number: true,
			},
			length: {
				required: true,
				number: true,
			},
			qty: {
				required: true,
				number: true,
			},
		},
		messages: {
			materialForm:{
				required: "Enter Material Form",
			},
			materialType: {
				required: "Enter Material Type",
			},
			thickness: {
				required: "Enter Thickness",
				number: "Enter Only Number ",
			},
			width: {
				required: "Enter Width",
				number: "Enter Only Number ",
			},
			length: {
				required: "Enter Length",
				number: "Enter Only Number ",
			},
			qty: {
				required: "Enter qty",
				number: "Enter Only Number ",
			},
		},
	});
	/*--------------------------------------
		Party Requirement - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Order - Add
	--------------------------------------*/
	$("#add-order-form").validate({
		rules: {
			party: {
				required: true,
			},
			dispatchDate: {
				required: true,
			},
			pbill: {
				required: true,
			},
			paymentCodition: {
				digits: true
			},
		},
		messages: {
			party:{
				required: "Select Party",
			},
			dispatchDate: {
				required: "Select Dispatch Date",
			},
			pbill: {
				required: "Select Bill Required",
			},
			paymentCodition: {
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Order - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Order - Add
	--------------------------------------*/
	$("#edit-order-form").validate({
		rules: {
			party: {
				required: true,
			},
			dispatchDate: {
				required: true,
			},
			pbill: {
				required: true,
			},
			paymentCodition: {
				digits: true
			},
		},
		messages: {
			party:{
				required: "Select Party",
			},
			dispatchDate: {
				required: "Select Dispatch Date",
			},
			pbill: {
				required: "Select Bill Required",
			},
			paymentCodition: {
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Order - Add Over
	--------------------------------------*/


	/*--------------------------------------
		Order - Add
	--------------------------------------*/
	$("#userChangePass").validate({
		rules: {
			oldPass: {
				required: true,
			},
			newPass: {
				required: true,
			},
			cNewPass: {
				required: true,
				equalTo: "#newPass"
			},
		},
		messages: {
			oldPass:{
				required: "Enter Current Password",
			},
			newPass: {
				required: "Enter New Password",
			},
			cNewPass: {
				required: "Enter Confirm Password",
				equalTo: "Confirm Password doesn't match with New Password",
			},
		},
	});
	/*--------------------------------------
		Order - Add Over
	--------------------------------------*/
});