$(document).ready(function() {
	var modal_focus = craoul = edit_row = delete_row = party_row = "";
	var base = $(".site_base").text().trim();
	var flag = true;
	var opts = {
		lines: 13,
		length: 0,
		width: 14,
		radius: 25,
		scale: 1,
		corners: 1,
		color: '#fff',
		opacity: 0.25,
		rotate: 0,
		direction: 1,
		speed: 1,
		trail: 60,
		fps: 20,
		zIndex: 2e9,
		className: 'spinner',
		top: '0',
		left: '50%',
		shadow: false,
		hwaccel: false,
		position: 'absolute'
	};
	new Spinner(opts).spin(document.getElementById('modal-loader-inner'));
	new Spinner(opts).spin(document.getElementById('requ-modal-loader-inner'));

	$(".sb-party-nav").addClass("active");

	$('.party-modal').on('shown.bs.modal', function (e) {
		modal_focus.focus();
	});

	function set_modal(title, form, focus, callback) {
		$.when($(".modal-loader-wrapper").hide())
		.then($(".party-modal span.input-error").remove())
		.then($(".party-modal form").hide())
		.then($(".party-modal form input[type='text'], .party-modal form select").val(""))
		.then($(".party-modal form #partyId").remove())
		.then($(".party-modal form textarea").val(""))
		.then($(".party-modal").find(".modal-title").text(title))
		.then($(".party-modal").find(form).show())
		.then(modal_focus = focus)
		.then(callback());
	}

	$(".party-add-nav").click(function() {

		set_modal("Add Party", "#add-party-form", $("#add-party-form #partyName"), function() {
			$(".party-modal").modal("show");
		});
	});

	$("#add-party-form").submit(function() {

		if($("#add-party-form").valid() && flag) {

			$(".modal-loader-wrapper").show();

			flag = false;
			
			$.ajax({
				url: base + "patron/party/add",
				type: "post",
				data: $("#add-party-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					$(".list-no-record").remove();
					$(".party-table tbody").append("<tr><td>"+$("#add-party-form #partyName").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #address").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #accountName").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #landLine").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #mobile").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #email").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #taxNo").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #panNo").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #reference").val().trim()+"</td><td class='text-center'>"+$("#add-party-form #remark").val().trim()+"</td><td class='text-center list-nav'><i class='fa fa-bars party-requi-nav' id='"+data.id+"'></i><i class='fa fa-pencil text-primary edit-row' id='"+data.id+"'></i><i class='fa fa-times text-danger delete-row' id='"+data.id+"'></i></td></tr>");
					$(".party-modal form input[type='text'], .party-modal form textarea").val("");
				}

				clearTimeout(craoul);
				$("#add-party-form div.callout").remove();
				$("#add-party-form").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $("#add-party-form div.callout").remove() }, 4000);

				$("#add-party-form #partyName").focus();
				$(".token").val(data.token_key);
				flag = true;
				$(".modal-loader-wrapper").hide();
			});
		}

		return false;
	});

	$("body").on("click", ".party-table tr td.list-nav .edit-row", function() {

		edit_row = $(this);

		set_modal("Edit Party", "#edit-party-form", $("#edit-party-form #partyName"), function() {

			$("#edit-party-form #partyName").val( edit_row.parents("tr").find("td:eq(0)").text().trim() );

			$("#edit-party-form #address").val( edit_row.parents("tr").find("td:eq(1)").text().trim() );

			$("#edit-party-form #accountName").val( edit_row.parents("tr").find("td:eq(2)").text().trim() );

			$("#edit-party-form #landLine").val( edit_row.parents("tr").find("td:eq(3)").text().trim() );

			$("#edit-party-form #mobile").val( edit_row.parents("tr").find("td:eq(4)").text().trim() );

			$("#edit-party-form #email").val( edit_row.parents("tr").find("td:eq(5)").text().trim() );

			$("#edit-party-form #taxNo").val( edit_row.parents("tr").find("td:eq(6)").text().trim() );

			$("#edit-party-form #panNo").val( edit_row.parents("tr").find("td:eq(7)").text().trim() );

			$("#edit-party-form #reference").val( edit_row.parents("tr").find("td:eq(8)").text().trim() );

			$("#edit-party-form #remark").val( edit_row.parents("tr").find("td:eq(9)").text().trim() );

			$("#edit-party-form").append("<input type='hidden' name='partyId' id='partyId' value='"+edit_row.attr("id")+"' >");

			$(".party-modal").modal("show");
		});
	});

	$("#edit-party-form").submit(function() {

		if($("#edit-party-form").valid() && flag) {

			flag = false;

			$(".modal-loader-wrapper").show();
			
			$.ajax({
				url: base + "patron/party/edit",
				type: "post",
				data: $("#edit-party-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					
					edit_row.parents("tr").find("td:eq(0)").text( $("#edit-party-form #partyName").val().trim() );

					edit_row.parents("tr").find("td:eq(1)").text( $("#edit-party-form #address").val().trim() );

					edit_row.parents("tr").find("td:eq(2)").text( $("#edit-party-form #accountName").val().trim() );

					edit_row.parents("tr").find("td:eq(3)").text( $("#edit-party-form #landLine").val().trim() );

					edit_row.parents("tr").find("td:eq(4)").text( $("#edit-party-form #mobile").val().trim() );

					edit_row.parents("tr").find("td:eq(5)").text( $("#edit-party-form #email").val().trim() );

					edit_row.parents("tr").find("td:eq(6)").text( $("#edit-party-form #taxNo").val().trim() );

					edit_row.parents("tr").find("td:eq(7)").text( $("#edit-party-form #panNo").val().trim() );

					edit_row.parents("tr").find("td:eq(8)").text( $("#edit-party-form #reference").val().trim() );

					edit_row.parents("tr").find("td:eq(9)").text( $("#edit-party-form #remark").val().trim() );

					$(".party-modal").modal("hide");

					clearTimeout(craoul);
					$(".box-parent-col div.callout").remove();
					$(".box-parent-col").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
					craoul = setTimeout(function(){ $(".box-parent-col div.callout").remove() }, 3000);
				}
				else {
					$("#edit-party-form").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
					$("#edit-party-form #partyName").focus();
				}

				$(".token").val(data.token_key);
				flag = true;
				$(".modal-loader-wrapper").hide();
			});
		}

		return false;
	});

	$("body").on("click", ".party-table tr td.list-nav .delete-row", function() {

		if(flag) {

			flag = false;

			$(this).append("<img src='"+base + "assets/img/general/spinner_red.gif" + "' />");

			delete_row = $(this);

			$.ajax({
				url: base + "patron/party/delete",
				type: "get",
				data: { id: delete_row.attr("id")},
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {
				
				if(data.type == "success") {
					delete_row.parents("tr").remove();
				}

				if( $(".party-table tbody tr").length == 0 ) {
					$(".party-table tbody").append("<tr class='list-no-record'><td class='text-center text-info' colspan='11'><b>No Record Found</b></td></tr>");
				}

				clearTimeout(craoul);
				$(".box-parent-col div.callout").remove();
				$(".box-parent-col").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $(".box-parent-col div.callout").remove() }, 3000);
				
				flag = true;
			});
		}
	});


	$("body").on("click", ".party-table tr td.list-nav .party-requi-nav", function() {

		$.when(party_row = $(this))
		.then($(".party-requirement-modal span.input-error").remove())
		.then($(".party-requirement-modal form").hide())
		.then($(".party-requirement-modal form input[type='text'], .party-requirement-modal form select").val(""))
		.then($(".party-requirement-modal form").append("<input type='hidden' name='partyId' id='partyId' value='"+party_row.attr("id")+"'>"))
		.then($(".party-requirement-table tbody tr.list-no-record").remove())
		.then($(".party-requirement-modal #add-party-requirement-form").show())
		.then($(".party-requirement-modal").modal("show"))
		.then(
			function() {

				$.ajax({
					url: base + "patron/party/requirement/fetch",
					type: "get",
					data: {party_id: party_row.attr("id"),},
					dataType: "JSON",
					encode: true
				})
				.done(function(data) {

					if( data.list.length > 0 ) {

						tmp = "";

						for (var i = 0; i < data.list.length; i++) {
							
							tmp += "<tr><td>"+data.list[i].material_form+"</td><td>"+data.list[i].material_type+"</td><td>"+data.list[i].thickness+"</td><td>"+data.list[i].width+"</td><td>"+data.list[i].length+"</td><td>"+data.list[i].qty+"</td><td class='list-nav'><i class='fa fa-pencil text-primary edit-row' id='"+data.list[i].id+"'></i><i class='fa fa-times text-danger delete-row' id='"+data.list[i].id+"'></i></td></tr>";
						}

						$(".party-requirement-table tbody tr").remove();
						$(".party-requirement-table tbody").append(tmp);
					}
					else {
						$(".party-requirement-table tbody tr").remove();
						$(".party-requirement-table tbody").append("<tr class='list-no-record'><td class='text-center text-info' colspan='11'><b>No Record Found</b></td></tr>");
					}
				});
			}
		);
	});

	$('.party-requirement-modal').on('shown.bs.modal', function (e) {
		$('#add-party-requirement-form #materialForm').focus();
	});

	$("#add-party-requirement-form").submit(function() {

		if( $("#add-party-requirement-form").valid() && flag ) {

			flag = false;

			$(".party-requ-mlw").show();

			$.ajax({
				url: base + "patron/party/requirement/add",
				type: "post",
				data: $("#add-party-requirement-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					$(".list-no-record").remove();
					$(".party-requirement-table tbody").append("<tr><td>"+$("#add-party-requirement-form #materialForm").val().trim()+"</td><td class='text-center'>"+$("#add-party-requirement-form #materialType").val().trim()+"</td><td class='text-center'>"+$("#add-party-requirement-form #thickness").val().trim()+"</td><td class='text-center'>"+$("#add-party-requirement-form #width").val().trim()+"</td><td class='text-center'>"+$("#add-party-requirement-form #length").val().trim()+"</td><td class='text-center'>"+$("#add-party-requirement-form #qty").val().trim()+"</td><td class='text-center list-nav'><i class='fa fa-pencil text-primary edit-row' id='"+data.id+"'></i><i class='fa fa-times text-danger delete-row' id='"+data.id+"'></i></td></tr>");

					$(".party-requirement-modal form input[type='text']").val("");
				}

				clearTimeout(craoul);
				$(".party-requirement-modal .modal-body div.callout").remove();
				$(".party-requirement-modal .modal-body").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $(".party-requirement-modal .modal-body div.callout").remove() }, 4000);

				$(".party-requirement-modal #materialForm").focus();
				$(".token").val(data.token_key);
				flag = true;
				$(".party-requ-mlw").hide();
			});
		}

		return false;
	});


	$("body").on("click", ".party-requirement-table tr td.list-nav .edit-row", function() {

		$.when(edit_row = $(this))
		.then($("#edit-party-requirement-form #materialForm").val( edit_row.parents("tr").find("td:eq(0)").text().trim() ))
		.then($("#edit-party-requirement-form #materialType").val( edit_row.parents("tr").find("td:eq(1)").text().trim() ))
		.then($("#edit-party-requirement-form #thickness").val( edit_row.parents("tr").find("td:eq(2)").text().trim() ))
		.then($("#edit-party-requirement-form #width").val( edit_row.parents("tr").find("td:eq(3)").text().trim() ))
		.then($("#edit-party-requirement-form #length").val( edit_row.parents("tr").find("td:eq(4)").text().trim() ))
		.then($("#edit-party-requirement-form #qty").val( edit_row.parents("tr").find("td:eq(5)").text().trim() ))
		.then($("#edit-party-requirement-form").append("<input type='hidden' name='requirementId' id='requirementId' value='"+edit_row.attr("id")+"' >"))
		.then($("#add-party-requirement-form").slideUp())
		.then($("#edit-party-requirement-form").slideDown())
		.then($("#edit-party-requirement-form #materialForm").focus());
	});

	$("#edit-party-requirement-form").submit(function() {

		if( $("#edit-party-requirement-form").valid() && flag ) {

			flag = false;

			$(".party-requ-mlw").show();

			$.ajax({
				url: base + "patron/party/requirement/edit",
				type: "post",
				data: $("#edit-party-requirement-form").serialize(),
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {

				if(data.type == "success") {
					edit_row.parents("tr").find("td:eq(0)").text( $("#edit-party-requirement-form #materialForm").val().trim() );
					edit_row.parents("tr").find("td:eq(1)").text( $("#edit-party-requirement-form #materialType").val().trim() );
					edit_row.parents("tr").find("td:eq(2)").text( $("#edit-party-requirement-form #thickness").val().trim() );
					edit_row.parents("tr").find("td:eq(3)").text( $("#edit-party-requirement-form #width").val().trim() );
					edit_row.parents("tr").find("td:eq(4)").text( $("#edit-party-requirement-form #length").val().trim() );
					edit_row.parents("tr").find("td:eq(5)").text( $("#edit-party-requirement-form #qty").val().trim() );
					$("#edit-party-requirement-form").slideUp();
					$("#add-party-requirement-form").slideDown();
					$("#add-party-requirement-form #materialForm").focus();
				}

				clearTimeout(craoul);
				$(".party-requirement-modal .modal-body div.callout").remove();
				$(".party-requirement-modal .modal-body").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $(".party-requirement-modal .modal-body div.callout").remove() }, 4000);

				$(".token").val(data.token_key);
				flag = true;
				$(".party-requ-mlw").hide();
			});
		}

		return false;
	});

	$(".close-party-edit").click(function() {
		$("#edit-party-requirement-form").slideUp();
		$("#add-party-requirement-form").slideDown();
		$("#add-party-requirement-form #materialForm").focus();
	});

	$("body").on("click", ".party-requirement-table tbody tr td.list-nav .delete-row", function() {

		if(flag) {

			flag = false;

			delete_row = $(this);

			delete_row.append("<img src='"+base + "assets/img/general/spinner_red.gif" + "' />");

			$.ajax({
				url: base + "patron/party/requirement/delete",
				type: "get",
				data: { id: delete_row.attr("id")},
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {
				
				if(data.type == "success") {
					delete_row.parents("tr").remove();
				}

				if( $(".party-requirement-table tbody tr").length == 0 ) {
					$(".party-requirement-table tbody").append("<tr class='list-no-record'><td class='text-center text-info' colspan='11'><b>No Record Found</b></td></tr>");
				}

				clearTimeout(craoul);
				$(".party-requirement-modal .modal-body div.callout").remove();
				$(".party-requirement-modal .modal-body").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){$(".party-requirement-modal .modal-body div.callout").remove()}, 4000);				
				flag = true;
			});
		}
	});
});