$(document).ready(function() {
	var trget = document.getElementById('modal-loader-inner');
	var modal_focus = craoul = edit_row = delete_row = "";
	var base = $(".site_base").text().trim();
	var flag = gridStatus = true;
	var total = 0;
	var opts = {
		 lines: 13,
		 length: 0,
		 width: 14,
		 radius: 25,
		 scale: 1,
		 corners: 1,
		 color: '#fff',
		 opacity: 0.25,
		 rotate: 0,
		 direction: 1,
		 speed: 1,
		 trail: 60,
		 fps: 20,
		 zIndex: 2e9,
		 className: 'spinner',
		 top: '0',
		 left: '50%',
		 shadow: false,
		 hwaccel: false,
		 position: 'absolute'
	};
	new Spinner(opts).spin(trget);
	var tbl_row = "<tr><td><select name='materialForm[]' class='form-control material-form'><option value=''>Select Form</option><option value='coil'>coil</option><option value='sheet'>sheet</option></select></td><td class='text-center'><select name='materialType[]' class='form-control material-type'><option value=''>Select Type</option><option value='crca'>crca</option><option value='hr'>hr</option><option value='pical'>pical</option><option value='gp'>gp</option></select></td><td class='text-center'><input type='text' name='thickness[]' class='form-control thickness' placeholder='Thickness'></td><td class='text-center'><input type='text' name='pwidth[]' class='form-control pwidth' placeholder='Width'></td><td class='text-center'><input type='text' name='plength[]' class='form-control plength' placeholder='Length'></td><td class='text-center'><input type='text' name='pqty[]' class='form-control pqty' placeholder='QTY'></td><td class='text-center'><input type='text' name='prate[]' class='form-control prate' placeholder='Rate'></td><td class='text-center list-nav'><i class='fa fa-times text-danger delete-row'></i></td></tr>";

	$(".sb-order-nav").addClass("active");

	$('.order-modal').on('shown.bs.modal', function (e) {
		modal_focus.focus();
	});

	$('.dispatchDate').datepicker({
		autoclose: true,
		format: 'dd/mm/yyyy',
		startDate: '+1d'
	}).on('change', function() {
		$(this).valid();
	});

	function set_modal(title, form, focus, callback) {
		$.when($(".modal-loader-wrapper").hide())
		.then($(".order-modal span.input-error").remove())
		.then($("div.order-grid-error").remove())
		.then($(".order-modal form").hide())
		.then($(".order-modal form input[type='text'], .order-modal form select").val(""))
		.then($(".order-modal form #purchaseId").remove())
		.then($(".order-modal form textarea").val(""))
		.then($(".order-modal").find(".modal-title").text(title))
		.then($(".order-modal").find(form).show())
		.then(modal_focus = focus)
		.then(callback());
	}

	$(".order-add-nav").click(function() {
		set_modal("Add Order", "#add-order-form", $("#add-order-form #party"), function() {
			$(".order-modal").modal("show");
		});
	});

	$("#add-order-form .add-order-table .add-more-td .add-more-nav").click(function() {
		$("#add-order-form .add-order-table tbody tr:last").before(tbl_row);
	});

	$("body").on("click", "#edit-order-form .edit-order-table .edit-more-td .edit-more-nav", function() {
		$("#edit-order-form .edit-order-table tbody tr:last").before(tbl_row);
	});

	$("body").on("click", ".add-order-table .list-nav .delete-row", function() {

		$(this).parents("tr").remove();
	});

	function validateOrderGrid() {

		gridStatus = true;

		total = 0;

		$("select.material-form").each(function (index) {

			if(
				$("select.material-form").eq(index).val().trim().length <= 0 ||
				$("select.material-type").eq(index).val().trim().length <= 0 ||
				$(".thickness").eq(index).val().trim().length <= 0 ||
				$(".pwidth").eq(index).val().trim().length <= 0 ||
				$(".plength").eq(index).val().trim().length <= 0 ||
				$(".pqty").eq(index).val().trim().length <= 0 ||
				$(".prate").eq(index).val().trim().length <= 0
			) {
				$("div.order-grid-error").remove();
				$(".first-row").after("<div class='callout callout-danger order-grid-error'>All fields are required</div>");
				gridStatus = false;
				return false;
			}
			else if(
				! $(".thickness").eq(index).val().match(/^\d+$/) ||
				! $(".pwidth").eq(index).val().match(/^\d+$/) ||
				! $(".plength").eq(index).val().match(/^\d+$/) ||
				! $(".pqty").eq(index).val().match(/^\d+$/) ||
				! $(".prate").eq(index).val().match(/^\d+$/)
			) {
				$("div.order-grid-error").remove();
				$(".first-row").after("<div class='callout callout-danger order-grid-error'>Only digits allow in Thickness, Width, Length, QTY and Rate</div>");
				gridStatus = false;
				return false;
			}
			else {
				total += ( $(".pqty").eq(index).val().trim() * $(".prate").eq(index).val().trim() );
			}
		});

		if(gridStatus) {
			$("div.order-grid-error").remove();
			return true;
		}
		else {
			return false;
		}
	}

	$("#add-order-form").submit(function() {

		if(validateOrderGrid() && $("#add-order-form").valid() && flag) {

			$.when(flag = false)

			.then($(".modal-loader-wrapper").show())

			.then($("#add-order-form #ttlAmt").val(total))

			.then(
				function() {
					$.ajax({
						url: base + "patron/order/add",
						type: "post",
						data: $("#add-order-form").serialize(),
						dataType: "JSON",
						encode: true
					})
					.done(function(data) {

						if(data.type == "success") {
							$(".list-no-record").remove();
							$(".order-table tbody").prepend("<tr><td>"+$("#add-order-form #orderId").text().trim()+"</td> <td class='text-center'>"+$("#add-order-form #orderDate").text().trim()+"</td> <td class='text-center'>"+$("#add-order-form #party option:selected").text().trim()+"<span class='dm-hide'>"+$("#add-order-form #party option:selected").val().trim()+"</span></td> <td class='text-center'>"+total+"</td> <td class='text-center'>"+$("#add-order-form #dispatchDate").val().trim()+"</td> <td class='text-center'>"+($("#add-order-form .pbill:checked").val().trim() == 0 ? "NO" : "YES")+"</td> <td class='text-center'>"+$("#add-order-form #paymentCodition").val().trim()+"</td> <td class='text-center'>"+$("#add-order-form #remark").val().trim()+"</td> <td class='text-center list-nav'><i class='fa fa-bars party-requi-nav' id='"+data.id+"'></i><i class='fa fa-pencil text-primary edit-row' id='"+data.id+"'></i><i class='fa fa-times text-danger delete-row' id='"+data.id+"'></i></td> </tr>");

							$(".add-order-table tbody tr").not(":first").not(":last").remove();

							$(".order-modal form input[type='text'], .order-modal form textarea, .order-modal form select").val("");
						}

						clearTimeout(craoul);
						$("#add-order-form div.callout").remove();
						$("#add-order-form").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
						craoul = setTimeout(function(){ $("#add-order-form div.callout").remove() }, 4000);

						$("#add-order-form #party").focus();
						$(".token").val(data.token_key);
						flag = true;
						$(".modal-loader-wrapper").hide();
					});
				}
			);
		}

		return false;
	});

	$("body").on("click", ".order-table tbody tr td.list-nav i.edit-row", function() {

		if(flag) {
			$("#edit-order-form div.edit-ldr").remove();
			edit_row = $(this);
			set_modal("Edit Order", "#edit-order-form", $("#edit-order-form #party"), function() {
				$("#edit-order-form").append("<div class='edit-ldr text-center'><img src='"+base + "assets/img/general/spinner.gif" + "' /></div>");
				$(".order-modal").modal("show");
				$.ajax({
					url: base + "patron/order/product/fetch",
					type: "get",
					data: {id: edit_row.attr("id")},
					dataType: "JSON",
					encode: true
				})
				.done(function(data) {
					$("#edit-order-form #orderId").text(edit_row.parents("tr").find("td:eq(0)").text().trim());
					$("#edit-order-form #orderDate").text(edit_row.parents("tr").find("td:eq(1)").text().trim());
					$("#edit-order-form #party").val(edit_row.parents("tr").find("td:eq(2) span").text().trim());
					$("#edit-order-form #dispatchDate").val(edit_row.parents("tr").find("td:eq(4)").text().trim());
					if(edit_row.parents("tr").find("td:eq(5)").text().trim() == "YES") {
						$("#edit-order-form input[name='pbill'][value='1']").prop("checked",true);
					}
					else {
						$("#edit-order-form input[name='pbill'][value='0']").prop("checked",true);	
					}
					$("#edit-order-form #paymentCodition").val(edit_row.parents("tr").find("td:eq(6) span").text().trim());
					$("#edit-order-form #remark").val(edit_row.parents("tr").find("td:eq(7)").text().trim());

					$("#edit-order-form .edit-order-table tbody tr").remove();

					for (var i = 0; i < data.list.length; i++) {

						ptmp = "<tr><td><select name='materialForm[]' class='form-control material-form'><option value=''>Select Form</option><option value='coil'>coil</option><option value='sheet'>sheet</option></select></td><td class='text-center'><select name='materialType[]' class='form-control material-type'><option value=''>Select Type</option><option value='crca'>crca</option><option value='hr'>hr</option><option value='pical'>pical</option><option value='gp'>gp</option></select></td><td class='text-center'><input type='text' name='thickness[]' class='form-control thickness' placeholder='Thickness'></td><td class='text-center'><input type='text' name='pwidth[]' class='form-control pwidth' placeholder='Width'></td><td class='text-center'><input type='text' name='plength[]' class='form-control plength' placeholder='Length'></td><td class='text-center'><input type='text' name='pqty[]' class='form-control pqty' placeholder='QTY'></td><td class='text-center'><input type='text' name='prate[]' class='form-control prate' placeholder='Rate'>";

						if(i > 0) {

							ptmp += "</td><td class='text-center list-nav'><i class='fa fa-times text-danger delete-row'></i></td></tr>";
						}
						
						$("#edit-order-form .edit-order-table tbody").append(ptmp);

						$("#edit-order-form .edit-order-table tbody tr:last select.material-form").val(data.list[i].material_form);
						$("#edit-order-form .edit-order-table tbody tr:last select.material-type").val(data.list[i].material_type);
						$("#edit-order-form .edit-order-table tbody tr:last .thickness").val(data.list[i].thickness);
						$("#edit-order-form .edit-order-table tbody tr:last .pwidth").val(data.list[i].pwidth);
						$("#edit-order-form .edit-order-table tbody tr:last .plength").val(data.list[i].plength);
						$("#edit-order-form .edit-order-table tbody tr:last .pqty").val(data.list[i].pqty);
						$("#edit-order-form .edit-order-table tbody tr:last .prate").val(data.list[i].prate);
					}

					$("#edit-order-form .edit-order-table tbody").append("<tr class='edit-more-tr'><td class='edit-more-td' colspan='8'><span class='text-info edit-more-nav'>Add More</span></td></tr>");

					$("#edit-order-form div.edit-ldr").remove();
					$("#edit-order-form .edit-order-form-wrapper").show();
				});
			});
		}
	});

	$("body").on("click", ".edit-order-table .list-nav .delete-row", function() {

		$(this).parents("tr").remove();
	});

	$("body").on("click", ".order-table tbody tr td.list-nav i.delete-row", function() {

		if(flag) {

			flag = false;

			$(this).append("<img src='"+base + "assets/img/general/spinner_red.gif" + "' />");

			delete_row = $(this);

			$.ajax({
				url: base + "patron/order/delete",
				type: "get",
				data: { id: delete_row.attr("id")},
				dataType: "JSON",
				encode: true
			})
			.done(function(data) {
				
				if(data.type == "success") {
					delete_row.parents("tr").remove();
				}

				if( $(".order-table tbody tr").length == 0 ) {
					$(".order-table tbody").append("<tr class='list-no-record'><td class='text-center text-info' colspan='11'><b>No Record Found</b></td></tr>");
				}

				clearTimeout(craoul);
				$(".box-parent-col div.callout").remove();
				$(".box-parent-col").prepend("<div class='callout callout-"+data.type+"'>"+data.message+"</div>");
				craoul = setTimeout(function(){ $(".box-parent-col div.callout").remove() }, 3000);
				
				flag = true;
			});
		}

		return false;
	});
});