<!DOCTYPE html>
<html>
	<head>
		<title>spin.js</title>
		<style type="text/css">
			body {
				font-family: Helvetica, Arial, sans-serif;
				font-size: 16px;
			}
			.preview {
				background: #aaa;
				color: black;
				width: 550px;
				height: 220px;
				margin: 0 20px;
				float: left;
				border-radius: 10px;
				position: relative;
			}
			#preview2 {
				background: #666;
				color: red;
			}
		</style>
	</head>

	<body>
		<div id="preview1" class="preview"></div>
		<div id="preview2" class="preview"></div>

		<script src="<?php echo base_url('assets/js/jquery.min.js')?>"></script>
		<script src="<?php echo base_url('assets/js/spin.js')?>"></script>
		<script>
			$(document).ready(function() {
				var opts = {
					 lines: 13 // The number of lines to draw
					, length: 0 // The length of each line
					, width: 14 // The line thickness
					, radius: 25 // The radius of the inner circle
					, scale: 1 // Scales overall size of the spinner
					, corners: 1 // Corner roundness (0..1)
					, color: '#fff' // #rgb or #rrggbb or array of colors
					, opacity: 0.25 // Opacity of the lines
					, rotate: 0 // The rotation offset
					, direction: 1 // 1: clockwise, -1: counterclockwise
					, speed: 1 // Rounds per second
					, trail: 60 // Afterglow percentage
					, fps: 20 // Frames per second when using setTimeout() as a fallback for CSS
					, zIndex: 2e9 // The z-index (defaults to 2000000000)
					, className: 'spinner' // The CSS class to assign to the spinner
					, top: '50%' // Top position relative to parent
					, left: '50%' // Left position relative to parent
					, shadow: false // Whether to render a shadow
					, hwaccel: false // Whether to use hardware acceleration
					, position: 'absolute' // Element positioning
				};
				var trget = document.getElementById('preview2');
				var spnr = new Spinner(opts).spin(trget);
			});
		</script>
	</body>
</html>