<div class="content-wrapper">
	<section class="content-header">
		<h1 class="content-header-text">
			<label>Purchase / Stock</label>
			<span class="btn btn-primary pull-right purchase-add-nav">Add</span>
		</h1>
	</section>

	<section class="content container-fluid">
		<div class="row">
			<div class="col-xs-12 box-parent-col">
				<div class="box box-primary">
					<div class="box-body table-responsive no-padding biz-box-body">
						<table class="table table-hover purchase-table">
							<thead>
								<tr>
									<th>Material Form</th>
									<th class="text-center">Material Type</th>
									<th class="text-center">Serial Number</th>
									<th class="text-center">Thickness</th>
									<th class="text-center">Width (MM)</th>
									<th class="text-center">Length (MM)</th>
									<th class="text-center">QTY</th>
									<th class="text-center">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if( $list->num_rows() > 0 ) {
										foreach ($list->result() as $row) {
											echo
											"<tr>
												<td>".$row->material_form."</td>
												<td class='text-center'>".$row->material_type."</td>
												<td class='text-center'>".$row->serial_no."</td>
												<td class='text-center'>".$row->thickness."</td>
												<td class='text-center'>".$row->width."</td>
												<td class='text-center'>".$row->length."</td>
												<td class='text-center'>".$row->qty."</td>
												<td class='text-center list-nav'>
													<i class='fa fa-pencil text-primary edit-row' id='".$row->id."'></i>
													<i class='fa fa-times text-danger delete-row' id='".$row->id."'></i>
												</td>
											</tr>";
										}
									}
									else {
										echo
										"<tr class='list-no-record'>
											<td class='text-center text-info' colspan='7'><b>No Record Found</b></td>
										</tr>";
									}
								?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>

<div class="modal fade purchase-modal" id="purchase-modal" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-loader-wrapper dm-hide"><div class="modal-loader-inner" id="modal-loader-inner"></div></div>
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"></h4>
			</div>
			<div class="modal-body">
				<form id="add-purchase-form">
					<div class="form-group">
						<label for="materialForm">Material Form</label>
						<select name="materialForm" id="materialForm" class="form-control">
							<option value="">-- Select Material Form --</option>
							<option value="coil">coil</option>
							<option value="sheet">sheet</option>
						</select>
					</div>

					<div class="form-group">
						<label for="materialType">Material Type</label>
						<select name="materialType" id="materialType" class="form-control">
							<option value="">-- Select Material Type --</option>
							<option value="crca">crca</option>
							<option value="hr">hr</option>
							<option value="pical">pical</option>
							<option value="gp">gp</option>
						</select>
					</div>

					<div class="form-group">
						<label for="serial_no">Serial Number</label>
						<input type="text" name="serial_no" id="serial_no" class="form-control" placeholder="Serial Number">
					</div>

					<div class="form-group">
						<label for="thickness">Thickness</label>
						<input type="text" name="thickness" id="thickness" class="form-control" placeholder="Thickness">
					</div>

					<div class="form-group">
						<label for="width">Width (MM)</label>
						<input type="text" name="width" id="width" class="form-control" placeholder="Width">
					</div>

					<div class="form-group">
						<label for="length">Length (MM)</label>
						<input type="text" name="length" id="length" class="form-control" placeholder="Length">
					</div>

					<div class="form-group">
						<label for="qty">QTY</label>
						<input type="text" name="qty" id="qty" class="form-control" placeholder="QTY">
					</div>

					<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">

					<div class="form-group text-right form-nav">
						<button type="submit" class="btn btn-primary">Save</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>

				<form id="edit-purchase-form">
					<div class="form-group">
						<label for="materialForm">Material Form</label>
						<select name="materialForm" id="materialForm" class="form-control">
							<option value="">-- Select Material Form --</option>
							<option value="coil">coil</option>
							<option value="sheet">sheet</option>
						</select>
					</div>

					<div class="form-group">
						<label for="materialType">Material Type</label>
						<select name="materialType" id="materialType" class="form-control">
							<option value="">-- Select Material Type --</option>
							<option value="crca">crca</option>
							<option value="hr">hr</option>
							<option value="pical">pical</option>
							<option value="gp">gp</option>
						</select>
					</div>

					<div class="form-group">
						<label for="serial_no">Serial Number</label>
						<input type="text" name="serial_no" id="serial_no" class="form-control" placeholder="Serial Number">
					</div>

					<div class="form-group">
						<label for="thickness">Thickness</label>
						<input type="text" name="thickness" id="thickness" class="form-control" placeholder="Thickness">
					</div>

					<div class="form-group">
						<label for="width">Width (MM)</label>
						<input type="text" name="width" id="width" class="form-control" placeholder="Width">
					</div>

					<div class="form-group">
						<label for="length">Length (MM)</label>
						<input type="text" name="length" id="length" class="form-control" placeholder="Length">
					</div>

					<div class="form-group">
						<label for="qty">QTY</label>
						<input type="text" name="qty" id="qty" class="form-control" placeholder="QTY">
					</div>

					<input type="hidden" name="<?php echo $token_name; ?>" value="<?php echo $token_key; ?>" class="token">

					<div class="form-group text-right form-nav">
						<button type="submit" class="btn btn-primary">Save</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript" src="<?php echo base_url('assets/js/admin/product.js') ?>"></script>