<div class="content-wrapper">
	<section class="content-header">
		<h1 class="content-header-text">
			<label>Orders</label>
			<span class="btn btn-primary pull-right order-add-nav">Add</span>
		</h1>
	</section>

	<section class="content container-fluid">
		<div class="row">
			<div class="col-xs-12 box-parent-col">
				<div class="box box-primary">
					<div class="box-body table-responsive no-padding biz-box-body">
						<div class="biz-box-body-loader-wrapper dm-hide"><div class="biz-box-body-loader-inner" id="biz-box-body-loader-inner"></div></div>
						<table class="table table-hover list-table order-table">
							<thead>
								<tr>
									<th>Ordre ID</th>
									<th class="text-center">Order Date</th>
									<th class="text-center">Party</th>
									<th class="text-center">Amount</th>
									<th class="text-center">Dispatch Date</th>
									<th class="text-center">Bill Required</th>
									<th class="text-center">Payment Condition</th>
									<th class="text-center">Remark</th>
									<th class="text-center">Status</th>
									<th class="text-center">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if($list->num_rows() > 0) {
										foreach ($list->result() as $row) {
								?>
											<tr data-id=<?php echo $row->id?>>
												<td><?php echo $row->id; ?></td>
												<td class="text-center"><?php echo date('d/m/Y', strtotime($row->order_date)); ?></td>
												<td class="text-center"> <span class="pname"><?php echo $row->name; ?></span><span class="dm-hide"><?php echo $row->pid; ?></span></td>
												<td class="text-center"><?php echo $row->ttl_amt; ?></td>
												<td class="text-center"><?php echo date('d/m/Y', strtotime($row->dispatch_date)); ?></td>
												<td class="text-center"><?php echo ($row->bill == 0 ? "NO" : "YES"); ?></td>
												<td class="text-center"><span><?php echo $row->pay_condition; ?></span> days</td>
												<td class="text-center"><?php echo $row->remark; ?></td>
												<td class="text-center"><?php echo $row->step; ?></td>
												<td class="text-center list-nav">
													<div class="dropdown action-dropdown">
														<button class="btn btn-default dropdown-toggle btn-block action-btn" type="button" id="action-menu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
															Action
															<span class="caret"></span>
														</button>
														<ul class="dropdown-menu dropdown-menu-right" role="menu" aria-labelledby="action-menu">
															<?php if($row->step != "dispatched") { ?>
															<li class="action-edit">Edit</li>
															<li class="action-status">Status</li>
															<li class="action-dispatch">Dispatch</li>
															<?php } else { ?>
															<li class="action-view">View</li>
															<li class="action-undispatch text-info">Un - Dispatch</li>
															<?php } ?>
															<li class="action-delete text-danger">Delete</li>
														</ul>
													</div>
												</td>
											</tr>
								<?php
										}
									}
									else {
								?>
										<tr class="list-no-record">
											<td class="text-center text-info" colspan="11"><b>No Record Found</b></td>
										</tr>
								<?php
									}
								?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>

<div class="modal fade order-modal" id="order-modal" data-backdrop="static" data-keyboard="false">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-loader-wrapper dm-hide"><div class="modal-loader-inner" id="modal-loader-inner"></div></div>
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"></h4>
			</div>
			<div class="modal-body">
				<form id="add-order-form">
					<div class="row">
						<label class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
							Order ID : <span id="orderId"><?php echo ($list->num_rows() > 0 ? ($list->row()->id + 1) : "1") ?></span>
						</label>
						<label class="col-lg-6 col-md-6 col-sm-6 col-xs-6 text-right">
							Date : <span id="orderDate"><?php echo date("d/m/Y"); ?></span>
						</label>
					</div>
					<div class="form-group first-row" style="margin-top: 15px;">
						<label for="party">Party</label>
						<select name="party" id="party" class="form-control">
							<option value="">-- Select Party --</option>
							<?php
								foreach ($party->result() as $row) {
							?>
									<option value="<?php echo $row->id;?>"><?php echo $row->name;?></option>
							<?php
								}
							?>
						</select>
					</div>
					<div class="table-responsive no-padding" style="overflow-x: visible;">
						<table class="table table-hover list-table add-order-table">
							<thead>
								<tr>
									<th class="text-center" style="padding-bottom: 0;">
										Product
										<p class="text-left dm-hide">
											<span>Material Form</span>
											<span>Material Type</span>
											<span>Serial No</span>
											<span>Thickness</span>
											<span>Width</span>
											<span>Length</span>
										</p>
									</th>
									<th class="text-center">QTY</th>
									<th class="text-center">Rate</th>
								</tr>
							</thead>
							<tbody>
								<?php for ($i = 0; $i <= 2; $i++) { ?>
								<tr>
									<td>
										<div class="dropdown prd-dropdown">
											<button class="btn btn-default dropdown-toggle btn-block prd-btn" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
												<span class="btn-txt">Select Product</span>
												<span class="caret"></span>
											</button>
											<ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
												<li class="li-head">
													<span>Material Form</span>
													<span>Material Type</span>
													<span>Serial No</span>
													<span>Thickness</span>
													<span>Width</span>
													<span>Length</span>
													<span>Stock</span>
												</li>
												<?php echo $pro;?>
											</ul>
										</div>
										<input type="hidden" name="product_id[]" class="form-control">
									</td>
									<td>
										<input type="text" name="pqty[]" class="form-control pqty" placeholder="QTY">
									</td>
									<td>
										<input type="text" name="prate[]" class="form-control prate" placeholder="Rate">
									</td>
									<td class='text-center list-nav'><i class='fa fa-times text-danger delete-row'></i></td>
								</tr>
								<?php } ?>
								
								<tr class="add-more-tr">
									<td class="add-more-td" colspan="4"><span class="text-info add-more-nav">Add More</span></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="row">
						<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
							<div class="form-group">
								<label>Dispatch Date</label>
								<div class="input-group date">
									<div class="input-group-addon">
										<i class="fa fa-calendar"></i>
									</div>
									<input type="text" name="dispatchDate" class="form-control dispatchDate" id="dispatchDate" placeholder="Dispatch Date" readonly="readonly">
								</div>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 text-center bill-required">
							<div class="form-group rgroup">
								<label style="display: block;">Bill Required ?</label>
								<div class="radio" style="margin-top: 4px; margin-bottom: 13px;">
									<label>
										<input type="radio" name="pbill" class="pbill" value="1" style="margin-left: -18px"> Yes
									</label>
									<label style="margin-left: 10px;">
										<input type="radio" name="pbill" class="pbill" value="0" style="margin-left: -18px"> No
									</label>
								</div>
							</div>
						</div>
						<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
							<div class="form-group">
								<label>Payment Condition in days</label>
								<input type="text" name="paymentCodition" class="form-control" id="paymentCodition" placeholder="Enter Payment Codition days">
							</div>
						</div>
					</div>
					<div class="form-group">
						<label>Remark</label>
						<textarea name="remark" class="form-control" id="remark" placeholder="Remark"></textarea>
					</div>
					<input type="hidden" name="ttlAmt" class="ttlAmt">
					<div class="form-group text-right form-nav">
						<button type="submit" class="btn btn-primary">Save</button>
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>

				<form id="edit-order-form">
					<p class="dm-hide text-center text-danger mdl-msg"></p>
					<div class="form-content dm-hide">
						<div class="row">
							<label class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
								Order ID : <span id="orderId"></span>
							</label>
							<label class="col-lg-6 col-md-6 col-sm-6 col-xs-6 text-right">
								Date : <span id="orderDate"></span>
							</label>
						</div>
						<div class="form-group first-row" style="margin-top: 15px;">
							<label for="party">Party</label>
							<select name="party" id="party" class="form-control">
								<option value="">-- Select Party --</option>
								<?php
									foreach ($allParty->result() as $row) {
								?>
										<option value="<?php echo $row->id;?>"><?php echo $row->name;?></option>
								<?php
									}
								?>
							</select>
						</div>
						<div class="table-responsive no-padding" style="overflow: visible;">
							<table class="table table-hover list-table edit-order-table">
								<thead>
									<tr>
										<th class="text-center">
											Product
											<p class="text-left">
												<span>Material Form</span>
												<span>Material Type</span>
												<span>Serial No</span>
												<span>Thickness</span>
												<span>Width</span>
												<span>Length</span>
											</p>
										</th>
										<th class="text-center">QTY</th>
										<th class="text-center" colspan="2">Rate</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td colspan="4" style="text-align: center;"><img src="<?php echo base_url('assets/img/general/spinner.gif');?>"></td>
									</tr>
								</tbody>
							</table>
						</div>
						<div class="row">
							<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
								<div class="form-group">
									<label>Dispatch Date</label>
									<div class="input-group date">
										<div class="input-group-addon">
											<i class="fa fa-calendar"></i>
										</div>
										<input type="text" name="dispatchDate" class="form-control dispatchDate" id="dispatchDate" placeholder="Dispatch Date" readonly="readonly">
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 text-center bill-required">
								<div class="form-group rgroup">
									<label style="display: block;">Bill Required ?</label>
									<div class="radio" style="margin-top: 4px; margin-bottom: 13px;">
										<label>
											<input type="radio" name="pbill" class="pbill" value="1" style="margin-left: -18px"> Yes
										</label>
										<label style="margin-left: 10px;">
											<input type="radio" name="pbill" class="pbill" value="0" style="margin-left: -18px"> No
										</label>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
								<div class="form-group">
									<label>Payment Condition in days</label>
									<input type="text" name="paymentCodition" class="form-control" id="paymentCodition" placeholder="Enter Payment Codition days">
								</div>
							</div>
						</div>
						<div class="form-group">
							<label>Remark</label>
							<textarea name="remark" class="form-control" id="remark" placeholder="Remark"></textarea>
						</div>
						<input type="hidden" name="ttlAmt" class="ttlAmt">
						<input type="hidden" name="order_id" id="order_id">
						<div class="form-group text-right form-nav">
							<button type="submit" class="btn btn-primary">Save</button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</form>

				<form id="order-status-form">
					<p class="dm-hide text-center text-danger mdl-msg"></p>
					<div class="form-content dm-hide">
						<div class="row">
							<label class="col-lg-4 col-md-4 col-sm-4 col-xs-4" id="status-orderId"></label>
							<label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 text-center" id="status-orderDate"></label>
							<label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 text-right" id="status-orderAmout"></label>
						</div>
						<div class="form-group first-row" style="margin-top: 15px;">
							<label for="party" id="status-orderParty"></label>
						</div>
						<div class="table-responsive no-padding">
							<table class="table table-hover">
								<thead>
									<tr>
										<th></th>
										<th class="text-center">Pendgin</th>
										<th class="text-center">Machine 1</th>
										<th class="text-center">Machine 2</th>
										<th class="text-center">Machine 3</th>
										<th class="text-center">Completed</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td colspan="6" class="text-center"><img src="<?php echo base_url('assets/img/general/spinner.gif');?>"></td>
									</tr>
								</tbody>
							</table>
						</div>
						<input type="hidden" name="status_order_id" id="status_order_id">
						<div class="form-group text-right form-nav">
							<button type="submit" class="btn btn-primary">Save</button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</form>

				<form id="order-dispatch-form">
					<p class="dm-hide text-center text-danger mdl-msg"></p>
					<div class="form-content dm-hide">
						<div class="row">
							<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12" id="dispatch-orderId"></label>
							<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12" id="dispatch-orderDate"></label>
							<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12 dispatch-dispatchDate"></label>
							<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12 dispatch-payCondition"></label>
						</div>
						<div class="form-group first-row" style="margin-top: 15px;">
							<label for="party" id="dispatch-orderParty"></label>
						</div>
						<div class="table-responsive no-padding">
							<table class="table table-hover">
								<thead>
									<tr>
										<th>No</th>
										<th class="text-center">M. Form</th>
										<th class="text-center">M. Type</th>
										<th class="text-center">Thickness</th>
										<th class="text-center">Width</th>
										<th class="text-center">Length</th>
										<th class="text-center">QTY</th>
										<th class="text-center">Rate</th>
										<th class="text-center">Total</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td colspan="9" class="text-center"><img src="<?php echo base_url('assets/img/general/spinner.gif');?>"></td>
									</tr>
								</tbody>
							</table>
						</div>
						<input type="hidden" name="dispatchOrderId" id="dispatchOrderId">
						<div class="form-group text-right form-nav">
							<button type="submit" class="btn btn-primary">Dispatch</button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</form>

				<form id="order-view-form">
					<div class="row">
						<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12" id="view-orderId"></label>
						<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12" id="view-orderDate"></label>
						<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12 view-dispatchDate"></label>
						<label class="col-lg-3 col-md-3 col-sm-6 col-xs-12 view-payCondition"></label>
					</div>
					<div class="row" style="margin-top: 15px;">
						<label class="col-lg-3 col-md-3 col-sm-3 col-xs-12" id="view-bill"></label>
						<label class="col-lg-9 col-md-9 col-sm-9 col-xs-12" id="view-orderParty"></label>
					</div>
					<div class="table-responsive no-padding">
						<table class="table table-hover">
							<thead>
								<tr>
									<th>No</th>
									<th class="text-center">M. Form</th>
									<th class="text-center">M. Type</th>
									<th class="text-center">Thickness</th>
									<th class="text-center">Width</th>
									<th class="text-center">Length</th>
									<th class="text-center">QTY</th>
									<th class="text-center">Rate</th>
									<th class="text-center">Total</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td colspan="9" class="text-center"><img src="<?php echo base_url('assets/img/general/spinner.gif');?>"></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="form-group text-right form-nav">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript" src="<?php echo base_url('assets/js/admin/orders.js') ?>"></script>