<?php

class PurchaseModel extends CI_Model {

	public function checkPurchase($post) {

		$check_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"serial_no" => trim($post["serial_no"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"status" => 1
		);

		return $this->db->get_where("product", $check_data);
	}

	public function setPurchase($post) {

		$add_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"serial_no" => trim($post["serial_no"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"],
			"status" => 1
		);

		return $this->db->insert("product", $add_data);
	}

	public function getPurchaseMaxId($post) {

		return $this->db

		->select_max("id")

		->where(array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"serial_no" => trim($post["serial_no"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"],
			"status" => 1
		))

		->get("product");
	}

	public function getAllPurchase() {

		return $this->db->where("status", 1)->order_by("id", "DESC")->get("product");
	}

	public function checkPurchaseForEdit($post) {

		$check_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"serial_no" => trim($post["serial_no"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"id !=" => $post["productId"]
		);

		return $this->db->get_where("product", $check_data);
	}

	public function editPurchase($post) {

		$edit_data = array (
			"material_form" => trim($post["materialForm"]),
			"material_type" => trim($post["materialType"]),
			"serial_no" => trim($post["serial_no"]),
			"thickness" => $post["thickness"],
			"width" => $post["width"],
			"length" => $post["length"],
			"qty" => $post["qty"]
		);

		return $this->db->update("product", $edit_data, array("id" => $post["productId"]));
	}

	public function deletePurchase($id) {

		return $this->db->where("id", $id)->update("product", array("status" => 0));
	}
}