<?php

class OrderModel extends CI_Model {

	public function getAllOrders() {

		return $this->db

		->select("odr.*, prt.name, prt.id AS pid")

		->from("orders odr")

		->join("party prt", "odr.party_id = prt.id", "INNER")

		->where("odr.status", 1)

		->order_by("id", "DESC")

		->get();
	}

	public function getAllProducts() {
		return $this->db->get_where("product", array("status" => 1));
	}

	public function searchProduct($values, $pids) {

		return $this->db->query("SELECT * FROM product WHERE id NOT IN (".implode(",", $pids).") AND (material_form REGEXP '$values' OR material_type REGEXP '$values' OR serial_no REGEXP '$values' OR thickness REGEXP '$values' OR width REGEXP '$values' OR length REGEXP '$values' OR qty REGEXP '$values')");
	}

	public function addOrder($post) {

		$add_data = array (
			"party_id" => $post["party"],
			"order_date" => date('Y-m-d'),
			"dispatch_date" => date("Y-m-d", strtotime(str_replace('/', '-', $post["dispatchDate"]))),
			"bill" => $post["pbill"],
			"pay_condition" => $post["paymentCodition"],
			"ttl_amt" => $post["ttlAmt"],
			"remark" => trim($post["remark"]),
			"step" => "pending",
			"penalty" => 0,
			"penalty_days" => 0,
			"status" => 1
		);

		return $this->db->insert("orders", $add_data);
	}

	public function getOrderMaxId($post) {

		return $this->db

		->select_max("id")

		->where(array (
			"order_date" => date('Y-m-d'),
			"party_id" => $post["party"],
			"dispatch_date" => date("Y-m-d", strtotime(str_replace('/', '-', $post["dispatchDate"]))),
			"bill" => $post["pbill"],
			"pay_condition" => $post["paymentCodition"],
			"ttl_amt" => $post["ttlAmt"],
			"remark" => trim($post["remark"]),
			"status" => 1
		))

		->get("orders");
	}

	public function addOrderDetail($id, $post) {

		$add_data = $prd_data = array ();

		foreach ($post["product_id"] as $key => $value) {

			if($value != "") {

				$arr = array (
					"order_id" => $id,
					"product_id" => $value,
					"pqty" => $post["pqty"][$key],
					"prate" => $post["prate"][$key],
					"process_status" => "pending"
				);

				array_push($add_data, $arr);

				$parr = array (
					"id" => $value,
					"qty" => '(qty - '.$post["pqty"][$key].')'
				);

				array_push($prd_data, $parr);
			}
		}

		$res = $this->db->insert_batch("orders_detail", $add_data);

		if($res) {
			$this->db->set_update_batch($prd_data, 'id', FALSE);
			$this->db->update_batch('product', NULL, 'id');
		}

		return $res;
	}

	public function getOrderProduct($order_id) {

		return $this->db

		->select("ord.id AS oid, ord.pqty, ord.prate, prd.id AS pid, prd.material_form, prd.material_type, prd.serial_no, prd.thickness, prd.width, prd.length, prd.qty")

		->from("orders_detail ord")

		->join("product prd", "ord.product_id = prd.id", "LEFT")

		->where("ord.order_id", $order_id)

		->get();
	}

	public function getById($id) {

		return $this->db->get_where("orders_detail", array("id" => $id));
	}

	public function deleteOrderProduct($id) {

		return $this->db

		->where("id", $id)

		->delete("orders_detail");
	}

	public function setQty($pid, $pqty) {

		$this->db

		->set('qty', 'qty + ' . $pqty, FALSE)

		->where('id', $pid)

		->update('product');
	}

	public function setTtlAmtForDelete($id, $amount) {

		$this->db

		->set('ttl_amt', 'ttl_amt - ' . $amount, FALSE)

		->where('id', $id)

		->update('orders');

		return $this->db->select("ttl_amt")->where("id", $id)->get("orders");
	}

	public function editOrder($post) {

		$edit_data = array (
			"party_id" => $post["party"],
			"dispatch_date" => date("Y-m-d", strtotime(str_replace('/', '-', $post["dispatchDate"]))),
			"bill" => $post["pbill"],
			"pay_condition" => $post["paymentCodition"],
			"ttl_amt" => $post["ttlAmt"],
			"remark" => trim($post["remark"]),
		);

		return $this->db->update("orders", $edit_data, array("id" => $post["order_id"]));
	}

	public function editOrderDetailQty($qty) {

		$edit_data = array();

		foreach ($qty as $key => $value) {

			$arr = array (
				"id" => $key,
				"pqty" => $value,
			);

			array_push($edit_data, $arr);
		}
		
		return $this->db->update_batch("orders_detail", $edit_data, "id");
	}

	public function editProductQty($qty) {

		$edit_data = array();

		foreach ($qty as $key => $value) {

			$arr = array (
				"id" => $key,
				"qty" => $value > 0 ? '(qty - '.$value.')' : '(qty + '.abs($value).')'
			);

			array_push($edit_data, $arr);
		}
		
		$this->db->set_update_batch($edit_data, 'id', FALSE);
		$this->db->update_batch('product', NULL, 'id');
	}

	public function editOrderDetailRate($rate) {

		$edit_data = array();

		foreach ($rate as $key => $value) {

			$arr = array (
				"id" => $key,
				"prate" => $value,
			);

			array_push($edit_data, $arr);
		}
		
		return $this->db->update_batch("orders_detail", $edit_data, "id");
	}

	public function getOrderById($id) {

		return $this->db->get_where("orders", array("id" => $id, "status" => 1));
	}

	public function deleteOrderProducts($order_id) {

		$ord_products = $this->db->get_where("orders_detail", array("order_id" => $order_id));

		if($ord_products->num_rows() > 0) {

			$edit_data = array();

			foreach ($ord_products->result() as $row) {

				$arr = array (
					"id" => $row->product_id,
					"qty" => '(qty + '.$row->pqty.')',
					"status" => 1
				);

				array_push($edit_data, $arr);
			}
		
			$this->db->set_update_batch($edit_data, 'id', FALSE);
			$this->db->update_batch('product', NULL, 'id');
		}
	}

	public function orderProductStatusFetch($order_id) {

		return $this->db

		->select("ord.id AS oid, ord.process_status, ord.pqty, prd.material_form, prd.material_type")

		->from("orders_detail ord")

		->join("product prd", "ord.product_id = prd.id", "LEFT")

		->where("ord.order_id", $order_id)

		->get();
	}

	public function orderProductStatusSave($post) {

		$edit_data = array(); $status_arr = array();

		foreach ($post as $key => $value) {

			if($key != "status_order_id") {

				$arr = array (
					"id" => filter_var($key, FILTER_SANITIZE_NUMBER_INT),
					"process_status" => $value,
				);

				array_push($status_arr, $value);

				array_push($edit_data, $arr);
			}
		}
		
		$this->db->update_batch("orders_detail", $edit_data, "id");

		if (array_unique($status_arr) === array("completed")) {
			
			$this->db->update("orders", array("step" => "completed"), array("id" => $post["status_order_id"]));

			return "completed";
		}
		else {

			$this->db->update("orders", array("step" => "pending"), array("id" => $post["status_order_id"]));

			return "pending";
		}
	}

	public function orderProductDispatchFetch($order_id) {

		return $this->db

		->select("prd.material_form, prd.material_type, prd.serial_no, prd.thickness, prd.width, prd.length, ord.pqty, ord.prate")

		->from("orders_detail ord")

		->join("product prd", "ord.product_id = prd.id", "LEFT")

		->where("ord.order_id", $order_id)

		->get();
	}

	public function orderDispatchWithPenalty($post) {

		$edit_data = array (
			"step" => "dispatched",
			"penalty" => $post["p_amt"],
			"penalty_days" => $post["p_days"],
			"dispatch_on" => date("Y-m-d")
		);

		return $this->db->update("orders", $edit_data, array("id" => $post["dispatchOrderId"]));
	}

	public function orderDispatch($order_id) {

		$edit_data = array (
			"step" => "dispatched",
			"dispatch_on" => date("Y-m-d")
		);

		return $this->db->update("orders", $edit_data, array("id" => $order_id));
	}

	public function fetchOrderForView($order_id) {

		return $this->db

		->select("ttl_amt, penalty, penalty_days")

		->from("orders")

		->where("id", $order_id)

		->get();
	}

	public function orderUndispatch($order_id) {

		$edit_data = array (
			"step" => "completed",
			"penalty" => 0,
			"penalty_days" => 0,
			"dispatch_on" => NULL,
		);

		return $this->db->update("orders", $edit_data, array("id" => $order_id));
	}

	public function deleteOrder($id) {

		return $this->db->update("orders", array("status" => 0), array("id" => $id));
	}
}