<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OrderController extends CI_Controller {

	public function fetchOrder() {
		
		$this->load->model("OrderModel");

		$this->load->model("PartyModel");

		$data["list"] = $this->OrderModel->getAllOrders();

		$data["party"] = $this->PartyModel->getAllParty();

		$data["allParty"] = $this->PartyModel->getAllParties();

		$prods = $this->OrderModel->getAllProducts();

		$prods_li = "";

		foreach ($prods->result() as $row) {
			$prods_li .= "<li id='".$row->id."'>";
			$prods_li .= "<span>".$row->material_form."</span>";
			$prods_li .= "<span>".$row->material_type."</span>";
			$prods_li .= "<span>".$row->serial_no."</span>";
			$prods_li .= "<span>".$row->thickness."</span>";
			$prods_li .= "<span>".$row->width."</span>";
			$prods_li .= "<span>".$row->length."</span>";
			$prods_li .= "<span>".$row->qty."</span>";
			$prods_li .= "</li>";

		}

		$data["pro"] = $prods_li;

		$data["token_name"] = $this->security->get_csrf_token_name();

		$data["token_key"] = $this->security->get_csrf_hash();

		$data["page"] = "orders";

		$this->load->view("patron/layout/wrapper", $data);
	}

	public function searchProduct() {

		$this->load->model("OrderModel");		

		$data["list"] = $this->OrderModel->searchProduct(str_replace(" ", "|", $this->input->get("srch")), json_decode($this->input->get("pids")))->result_array();

		echo json_encode($data);
	}

	public function addOrder() {

		$this->load->model("OrderModel");

		if($this->input->get("product_id") && count($this->input->get("product_id")) > 0) {

			$order = $this->OrderModel->addOrder($this->input->get());

			if($order) {

				$id = $this->OrderModel->getOrderMaxId($this->input->get())->row()->id;

				$order_detail = $this->OrderModel->addOrderDetail($id, $this->input->get());

				$data = array ( "type" => "success", "message" => "Order added successfully.", "id" => $id);
			}
			else {
				$data = array ( "type" => "danger", "message" => "Something went wrong. Try after sometime.");
			}

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function orderProduct() {

		$this->load->model("OrderModel");

		$data["list"] = $this->OrderModel->getOrderProduct($this->input->get("order_id"))->result();

		echo json_encode($data);

		exit;
	}

	public function deleteOrderProduct() {

		$this->load->model("OrderModel");

		$exited = $this->OrderModel->getById($this->input->get("ord_prd_id"));

		if($exited->num_rows() == 1) {

			$deleteOrdPrd = $this->OrderModel->deleteOrderProduct($exited->row()->id);

			if($deleteOrdPrd) {

				$this->OrderModel->setQty($exited->row()->product_id, $exited->row()->pqty);

				$data["amt"] = $this->OrderModel->setTtlAmtForDelete($exited->row()->order_id, ($exited->row()->pqty * $exited->row()->prate))->row()->ttl_amt;

				$data["pid"] = $exited->row()->product_id;

				$data["status"] = true;
			}

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function editOrder() {

		if($this->input->get("ord_prd_id") && count($this->input->get("ord_prd_id")) > 0) {	

			$this->load->model("OrderModel");

			$editOrd = $this->OrderModel->editOrder($this->input->get());

			if($editOrd) {

				$ordDtlQty = json_decode($this->input->get("ordDtlQtyJSON"), true);
				$proQty = json_decode($this->input->get("proQtyJSON"), true);

				if(count($ordDtlQty) > 0 && count($ordDtlQty) == count($proQty) ) {

					$editOrdDtlQty = $this->OrderModel->editOrderDetailQty($ordDtlQty);

					if($editOrdDtlQty > 0) {

						$editProQty = $this->OrderModel->editProductQty($proQty);
					}
				}

				$ordDtlRate = json_decode($this->input->get("ordDtlRateJSON"), true);

				if(count($ordDtlRate) > 0) {

					$editOrdDtlRate = $this->OrderModel->editOrderDetailRate($ordDtlRate);
				}

				if($this->input->get("product_id") && count($this->input->get("product_id")) > 0) {

					$order_detail = $this->OrderModel->addOrderDetail($this->input->get("order_id"), $this->input->get());
				}

				$data["status"] = "success";
			}
			else {
				$data["status"] = "failed";
			}

			echo json_encode($data);
			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function orderProductStatusFetch() {

		$this->load->model("OrderModel");

		$exited = $this->OrderModel->getOrderById($this->input->get("order_id"));

		if($exited->num_rows() == 1) {

			$data["list"] = $this->OrderModel->orderProductStatusFetch($this->input->get("order_id"))->result();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function orderProductStatusSave() {

		$this->load->model("OrderModel");

		$data["status"] = $this->OrderModel->orderProductStatusSave($this->input->get());

		echo json_encode($data);

		exit;
	}

	public function orderProductDispatchFetch() {

		$this->load->model("OrderModel");

		$exited = $this->OrderModel->getOrderById($this->input->get("order_id"));

		if($exited->num_rows() == 1) {

			$data["list"] = $this->OrderModel->orderProductDispatchFetch($this->input->get("order_id"))->result();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function orderDispatch() {

		$this->load->model("OrderModel");

		$post = $this->input->get();

		if(isset($post["p_amt"]) && isset($post["p_days"])) {

			$data["status"] = $this->OrderModel->orderDispatchWithPenalty($post);
		}
		else {

			$data["status"] = $this->OrderModel->orderDispatch($post["dispatchOrderId"]);
		}

		echo json_encode($data);

		exit;
	}

	public function orderView() {

		$this->load->model("OrderModel");

		$exited = $this->OrderModel->getOrderById($this->input->get("order_id"));

		if($exited->num_rows() == 1) {

			$data["list"] = $this->OrderModel->orderProductDispatchFetch($this->input->get("order_id"))->result();

			$data["ord"] = $exited->row();

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}

	public function orderUndispatch() {

		$this->load->model("OrderModel");

		$dispatched = $this->OrderModel->orderUndispatch($this->input->get("order_id"));

		if($dispatched) {
			$data = array ( "type" => "success", "message" => "Order Dispatched successfully.");
		}
		else {
			$data = array ( "type" => "success", "message" => "Something went wrong. Try after sometime.");
		}

		echo json_encode($data);

		exit;
	}

	public function deleteOrder() {

		$this->load->model("OrderModel");

		$exited = $this->OrderModel->getOrderById($this->input->get("id"));

		if($exited->num_rows() == 1) {

			$delete = $this->OrderModel->deleteOrder($exited->row()->id);

			if($delete) {
				$this->OrderModel->deleteOrderProducts($exited->row()->id);
				$data = array ( "type" => "success", "message" => "Order deleted successfully.");
			}
			else {
				$data = array ( "type" => "danger", "message" => "Something went wrong. Try after sometime.");
			}

			echo json_encode($data);

			exit;
		}
		else {
			redirec(base_url('out'));
		}
	}
}