<?php
defined("BASEPATH") OR exit("No direct script access allowed");

$route["default_controller"] = "UserController/getLockView";
$route["404_override"] = "";
$route["translate_uri_dashes"] = FALSE;


$route["test"] = "TestController/index";

/* ------------------------------------ USER ROUTES ------------------------------------ */

$route["lock/auth"]["get"]				=	"UserController/getLockView";

$route["lock/auth"]["post"]				=	"UserController/getLockAuth";

$route["user/change_pass"]["get"]		=	"UserController/changePassword";

$route["user/pass/change"]["get"]		=	"UserController/setNewPass";

$route["out"]["get"]					=	"UserController/out";

/* ------------------------------------ USER ROUTES OVER ------------------------------- */



/* ------------------------------------ PURCHASE ROUTES ------------------------------------ */

$route["patron/purchase"]					=	"ProductController/index";

$route["patron/purchase/add"]["post"]		=	"ProductController/addPurchase";

$route["patron/purchase/edit"]["post"]		=	"ProductController/editPurchase";

$route["patron/purchase/delete"]["get"]		=	"ProductController/deletePurchase";

/* ------------------------------------ PURCHASE ROUTES OVER ------------------------------- */



/* ------------------------------------ PARTY ROUTES ------------------------------------ */

$route["patron/party"]					=	"PartyController/index";

$route["patron/party/add"]["post"]		=	"PartyController/addParty";

$route["patron/party/edit"]["post"]		=	"PartyController/editParty";

$route["patron/party/delete"]["get"]	=	"PartyController/deleteParty";

/* ------------------------------------ PARTY ROUTES OVER ------------------------------------ */



/* ------------------------------------ PARTY REQUIREMENT ROUTES ------------------------------------ */

$route["patron/party/requirement/fetch"]["get"]		=	"PartyRequController/fetchRequirement";

$route["patron/party/requirement/add"]["post"]		=	"PartyRequController/addRequirement";

$route["patron/party/requirement/edit"]["post"]		=	"PartyRequController/editRequirement";

$route["patron/party/requirement/delete"]["get"]	=	"PartyRequController/deleteRequirement";

/* ------------------------------------ PARTY REQUIREMENT ROUTES OVER ------------------------------------ */



/* ------------------------------------ ORDER ROUTES ------------------------------------ */

$route["patron/order"]["get"]							=	"OrderController/fetchOrder";

$route["patron/order/add"]["get"]						=	"OrderController/addOrder";

$route["patron/order/product/fetch"]["get"]				=	"OrderController/orderProduct";

$route["patron/order/product/delete"]["get"]			=	"OrderController/deleteOrderProduct";

$route["patron/order/edit"]["get"]						=	"OrderController/editOrder";

$route["patron/order/product/status/fetch"]["get"]		=	"OrderController/orderProductStatusFetch";

$route["patron/order/product/status/save"]["get"]		=	"OrderController/orderProductStatusSave";

$route["patron/order/product/dispatch/fetch"]["get"]	=	"OrderController/orderProductDispatchFetch";

$route["patron/order/dispatch"]["get"]					=	"OrderController/orderDispatch";

$route["patron/order/view"]["get"]						=	"OrderController/orderView";

$route["patron/order/undispatch"]["get"]				=	"OrderController/orderUndispatch";

$route["patron/order/delete"]["get"]					=	"OrderController/deleteOrder";

/* ------------------------------------ ORDER ROUTES OVER ------------------------------------ */