<?php defined('BASEPATH') OR exit('No direct script access allowed');

class GetUpController extends CI_Controller {

	public $top_sold = "";

	public function __construct() {
		parent::__construct();
		$this->load->model("FrontModel");
		$this->top_sold = $this->FrontModel->getTopSold();
	}

	public function getHome() {

		$data["csrf_name"] = $this->security->get_csrf_token_name();

		$data["csrf_hash"] = $this->security->get_csrf_hash();

		$data["products"] = $this->FrontModel->getHomeProduct();

		$data["top"] = $this->FrontModel->getTopSold();

		$data["page"] = "site/home";

		$this->load->view("layout/site", $data);
	}

	public function showUserProfile()
	{
		if (isset($this->session->user_id))
		{
			$user = $this->FrontModel->getUserById($this->session->user_id);

			if($user->num_rows() == 1 && $user->row()->is_active == 1)
			{
				$data["page"] = "site/user_profile";
				$data["user"] = $user->row();
				$data["addr_type_home"] = (empty($user->row()->address_type) || $user->row()->address_type == "home") ? "checked" : "";
				$data["addr_type_buss"] = ($user->row()->address_type == "business") ? "checked" : "";
				$data["csrf_name"] = $this->security->get_csrf_token_name();
				$data["csrf_hash"] = $this->security->get_csrf_hash();
				$this->load->view("layout/site", $data);
			}
			else
			{
				redirect(base_url());
			}
		}
		else {
			redirect(base_url());
		}
	}

	public function saveUserProfile()
	{
		$response = ["status" => 2, "msg" => "Something went wrong. Try after sometime"];

		if($this->input->is_ajax_request())
		{
			$post = $this->input->post();

			if( isset($post["appUserFirstName"]) && isset($post["appUserLastName"]) && isset($post["appUserEmail"]) && isset($post["appUserMobile"]) && isset($post["appUserAddress"]) && isset($post["appUserAddressLocality"]) && isset($post["appUserAddressCity"]) && isset($post["appUserAddressState"]) && isset($post["appUserAddressPincode"]) && isset($post["appUserAddressType"]) && ( $post["appUserAddressType"] === "home" || $post["appUserAddressType"] === "business" ) && count($post) == 10 )
			{
				$error = [];

				if(empty(trim($post["appUserFirstName"])))
				{
					$error["appUserFirstName"] = "Enter first name";
				}
				else if(preg_match("/[^a-zA-Z]/", $post["appUserFirstName"]))
				{
					$error["appUserFirstName"] = "Invalid first name. Allowed only a-z";
				}

				if(empty(trim($post["appUserLastName"])))
				{
					$error["appUserLastName"] = "Enter first name";
				}
				else if(preg_match("/[^a-zA-Z]/", $post["appUserLastName"]))
				{
					$error["appUserLastName"] = "Invalid last name. Allowed only a-z";
				}

				if(empty(trim($post["appUserEmail"])))
				{
					$error["appUserEmail"] = "Enter email address";
				}
				else if(!filter_var($post["appUserEmail"], FILTER_VALIDATE_EMAIL))
				{
					$error["appUserEmail"] = "Invalid email address";
				}

				if(empty(trim($post["appUserMobile"])))
				{
					$error["appUserMobile"] = "Enter mobile number";
				}
				else if(preg_match("/[^0-9]/", $post["appUserMobile"]))
				{
					$error["appUserMobile"] = "Invalid mobile number. Allowed only digits";
				}
				if(strlen($post["appUserMobile"]) > 15)
				{
					$error["appUserMobile"] = "Mobile number maximum 15 digit long";
				}

				if(empty(trim($post["appUserAddress"])))
				{
					$error["appUserAddress"] = "Enter address";
				}

				if(empty(trim($post["appUserAddressLocality"])))
				{
					$error["appUserAddressLocality"] = "Enter locality";
				}

				if(empty(trim($post["appUserAddressCity"])))
				{
					$error["appUserAddressCity"] = "Enter city";
				}

				if(empty(trim($post["appUserAddressState"])))
				{
					$error["appUserAddressState"] = "Enter city";
				}

				if(empty(trim($post["appUserAddressPincode"])))
				{
					$error["appUserAddressPincode"] = "Enter pin code";
				}
				else if(preg_match("/[^0-9]/", $post["appUserAddressPincode"]))
				{
					$error["appUserAddressPincode"] = "Invalid pin code. Allowed only digits";
				}

				if(empty($error))
				{
					$check_email = $this->FrontModel->checkEmailToEdit($post["appUserEmail"], $this->session->user_id);

					$check_mobile = $this->FrontModel->checkMobileToEdit($post["appUserMobile"], $this->session->user_id);

					if($check_email->num_rows() > 0)
					{
						$error["appUserEmail"] = "This email address alredy existed. Provide another email address";
					}

					if($check_email->num_rows() > 0)
					{
						$error["appUserMobile"] = "This mobile number alredy existed. Provide another mobile number";
					}

					if(empty($error))
					{
						$edit = $this->FrontModel->saveUserProfile($post, $this->session->user_id);

						if($edit)
						{
							$response = ["status" => 0, "msg" => "Detail saved successfully"];
						}
					}
				}
				else
				{
					$response = ["status" => 1, "error" => $error];
				}
			}
		}

		$response["token"] = $this->security->get_csrf_hash();
		echo json_encode($response);
		exit;
	}

	public function getAllProducts() {

		$data["list"] = $this->FrontModel->getAllProducts()->result();

		$mainCat = $this->FrontModel->getAllMainCategory();

		$left = "";

		if ($mainCat->num_rows() > 0) {

			foreach ($mainCat->result() as $row) {
				
				if ($row->sub_cat == "YES") {

					$subCat = $this->FrontModel->getSubCatByMain($row->id);

					if ($subCat->num_rows() > 0) {

						$left .= "<li class='sub-cat'>".$row->name."<ul>";

						foreach ($subCat->result() as $sub_row) {

							$left .= "<li data-sup-alias='".$row->alias."' data-sub-alias='".$sub_row->alias."'>".$sub_row->name."</li>";
						}

						$left .= "</ul></li>";
					}
				}
				else {

					$left .= "<li class='main-cat' data-alias='".$row->alias."'>".$row->name."</li>";
				}
			}
		}

		$data["left"] = $left;

		$data["csrf_name"] = $this->security->get_csrf_token_name();

		$data["csrf_hash"] = $this->security->get_csrf_hash();

		$data["page"] = "site/all_products";

		$this->load->view("layout/site", $data);
	}

	public function userAuth() {

		if ($this->input->is_ajax_request() && ! isset($this->session->user_id) )
		{
		
			$user = $this->FrontModel->checkAuth($this->input->post());

			if ($user->num_rows() == 1) {

				if ($user->row()->is_active == 1) {

					$this->session->set_userdata("user_id", $user->row()->id);

					$data["auth"] = true;
				}
				else {

					$data["token"] = $this->security->get_csrf_hash();

					$data["activation"] = true;
				}
			}
			else {

				$data["token"] = $this->security->get_csrf_hash();

				$data["auth"] = false;
			}

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function userReg() {

		if ($this->input->is_ajax_request() && ! isset($this->session->user_id))
		{
			$email_existed = $this->FrontModel->checkEmail($this->input->post("emailId"));

			if ($email_existed->num_rows() >= 1) {

				$data["email"] = true;
			}
			else {

				$registration_at = date("Y-m-d H:i:s");

				$emailKey = md5(date("l, F d, Y h:i" ,time()) . (microtime()) . $this->input->post("firstName"));

				$emailKey .= md5(date("l, F d, Y h:i" ,time()) . (microtime()) . $this->input->post("lastName"));

				$emailKey .= md5(date("l, F d, Y h:i" ,time()) . (microtime()) . $this->input->post("emailId"));

				$data["emailKey"] = $emailKey;

				$new = $this->FrontModel->addUser($this->input->post(), $registration_at, $emailKey);

				if ($new) {

					$nUser = $this->FrontModel->getNewUser($this->input->post(), $registration_at, $emailKey)->row();

					$this->load->library('email');

					$email_config['protocol'] = 'sendmail';
					$email_config['charset'] = 'iso-8859-1';
					$email_config['wordwrap'] = TRUE;
					$email_config['mailtype'] = "html";

					$this->email->initialize($email_config);

					$this->email->from('account@aelshop.co.uk', 'AEL Shop');
					$this->email->to(trim($this->input->post("emailId")));

					$this->email->subject('AEL Email Verification');
					$this->email->message('Click below link : <br/><br/>' . base_url('user/activation/' . $emailKey));

					if(!$this->email->send()) {
						$data["email_error"] = "";
					}

					$data["status"] = true;
				}
				else {

					$data["token"] = $this->security->get_csrf_hash();

					$data["resource"] = true;
				}
			}

			$data["token"] = $this->security->get_csrf_hash();

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function aboutUs() {

		$data["csrf_name"] = $this->security->get_csrf_token_name();

		$data["csrf_hash"] = $this->security->get_csrf_hash();

		$data["page"] = "site/about";

		$this->load->view("layout/site", $data);
	}

	public function contactUs() {

		$data["csrf_name"] = $this->security->get_csrf_token_name();

		$data["csrf_hash"] = $this->security->get_csrf_hash();

		$data["page"] = "site/contact";

		$this->load->view("layout/site", $data);
	}

	public function userActivation($key)
	{
		if(!empty(trim($key)))
		{
			$this->load->model("FrontModel");

			$user = $this->FrontModel->getUserByEmailKey($key);

			if($user->num_rows() == 1)
			{
				$active = $this->FrontModel->setUserActive($key);

				if($active)
				{
					redirect(base_url());
					exit;
				}
			}
		}

		$this->load->view("site/404.php");
	}

	public function addToCart() {

		if ($this->input->is_ajax_request()) {

			if (isset($this->session->user_id)) {

				$existed = $this->FrontModel->productInCart($this->session->user_id, $this->input->post("selProId"));

				if ( $existed->num_rows() == 1 ) {

					$nQty = $existed->row()->qty + $this->input->post("qty");

					$data["status"] = $this->FrontModel->incQty($this->session->user_id, $this->input->post("selProId"), $nQty);
				}
				else {
					
					$data["status"] = $this->FrontModel->addToCart($this->input->post(), $this->session->user_id);
				}
			}
			else {

				$data["auth"] = true;
			}

			$data["token"] = $this->security->get_csrf_hash();

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function checkAuth() {

		if ($this->input->is_ajax_request()) {

			if (isset($this->session->user_id)) {

				$data["status"] = true;
			}
			else {

				$data["status"] = false;
			}

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function fetchCart() {

		if (isset($this->session->user_id)) {

			$data["csrf_hash"] = $this->security->get_csrf_hash();

			$data["products"] = $this->FrontModel->getCartProducts($this->session->user_id);

			$data["page"] = "site/cart23";

			$this->load->view("layout/site", $data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function userInquiry() {

		if ($this->input->is_ajax_request()) {

			$data["status"] = $this->FrontModel->setInquiry($this->input->get());

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function getMainCatProductByAlias($cat_alias, $product_alias) {

		$product = $this->FrontModel->getMainCatProductByAlias($cat_alias, $product_alias);

		if ($product->num_rows() == 1 && $product->row()->status == 1) {

			$data = $this->getProductDetail($product);

			$data["breadcrumb"] = $product->row()->cat . " / ";

			$data["oprice"] = ($product->row()->price - (($product->row()->price * $product->row()->cat_discount) / 100));
		}
		else {

			$data["page"] = "site/404";
		}

		$this->load->view("layout/site", $data);
	}

	public function getSubCatProductByAlias($cat_alias, $sub_cat_alias, $product_alias) {

		$product = $this->FrontModel->getSubCatProductByAlias($cat_alias, $sub_cat_alias, $product_alias);

		if ($product->num_rows() == 1 && $product->row()->status == 1) {

			$data = $this->getProductDetail($product);

			$data["breadcrumb"] = $product->row()->cat . " / " .$product->row()->subcat . " / " ;

			$data["oprice"] = ($product->row()->price - (($product->row()->price * $product->row()->sub_discount) / 100));
		}
		else {

			$data["page"] = "site/404";
		}

		$this->load->view("layout/site", $data);
	}

	public function getProductDetail($product) {

		$proDiv = "<div class='slide'><img src='".base_url('assets/img/product/'.$product->row()->img_1)."'></div>";
		$proLi = "<li><div class='img'><img src='".base_url('assets/img/product/'.$product->row()->img_1)."'></div></li>";

		for($i = 2; $i < 6; $i++) {

			$tmp = "img_" . $i;

			if ($product->row()->$tmp !== "") {

				$proDiv .= "<div class='slide'><img src='".base_url('assets/img/product/'.$product->row()->$tmp)."'></div>";

				$proLi .= "<li><div class='img'><img src='".base_url('assets/img/product/'.$product->row()->$tmp)."'></div></li>";
			}
		}

		return array (
			"proDiv" => $proDiv,
			"proLi" => $proLi,
			"pro" => $product->row(),
			"csrf_name" => $this->security->get_csrf_token_name(),
			"csrf_hash" => $this->security->get_csrf_hash(),
			"page" => "site/product_detail"
		);		
	}

	public function searchMainCatProduct($cat_alias) {

		if ($this->input->is_ajax_request()) {

			$category = $this->FrontModel->getMainCatIdByAlias($cat_alias);

			if ($category->num_rows() == 1) {

				$products = $this->FrontModel->searchMainCatProduct($category->row()->id);

				if ( $products->num_rows() > 0 ) {

					$data["list"] = $products->result();
				}
				else {
					
					$data["empty"] = true;
				}
			}
			else {

				$data["empty"] = true;
			}

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function searchProduct() {
		if ($this->input->is_ajax_request()) {

			$data["list"] = $this->FrontModel->getProdctBySearch($this->input->get("pname"))->result();

			echo json_encode($data);
		}
		else {
			redirect(base_url("out"));
		}
	}

	public function searchSubCatProduct($cat_alias, $sub_cat_alias) {

		if ($this->input->is_ajax_request()) {

			$sub = $this->FrontModel->getSubCatIdByAlias($cat_alias, $sub_cat_alias);

			if ($sub->num_rows() == 1) {

				$products = $this->FrontModel->searchSubCatProduct($sub->row()->catid, $sub->row()->subid);

				if ($products->num_rows() > 0) {

					$data["list"] = $products->result();
				}
				else {
					
					$data["empty"] = true;

					$data["test"] = true;
				}
			}
			else {

				$data["empty"] = true;
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function removeCartItem($item_id)
	{
		$response = ["status" => 2, "msg" => "Something went wrong. Try after sometime"];

		if( ! empty($this->session->user_id) && $this->input->is_ajax_request() && !empty(trim($item_id)) && ctype_digit($item_id))
		{
			$product = $this->FrontModel->getCartProductById($item_id);

			if($product->num_rows() == 1)
			{
				$delete = $this->FrontModel->deleteCartProduct($item_id);

				if($delete)
				{
					$response = ["status" => 0, "msg" => "Product successfully removed from cart"];
				}
			}
		}

		echo json_encode($response);
		exit;
	}
}