$(document).ready(function() {

	$.validator.setDefaults({
		ignore: [],
		errorElement: "span",
		errorClass: "text-danger",
		validClass: "valid",
		onfocusout: false,
		errorPlacement: function(error, element) {
			var placement = $(element).data('error');
			if (placement) {
				$(placement).append(error)
			}
			else {
				error.insertAfter(element);
			}
		}
	});

	/*--------------------------------------
		Admin Login
	--------------------------------------*/
	$("#cherisAuthForm").validate({
		rules: {
			userName: {
				required: true,
			},
			userPass: {
				required: true,
			},
		},
		messages: {
			userName:{
				required: "Enter username",
			},
			userPass: {
				required: "Enter password",
			},
		},
	});
	/*--------------------------------------
		Admin Login Over
	--------------------------------------*/


	/*--------------------------------------
		Main Category
	--------------------------------------*/
	$("#add-category").validate({
		rules: {
			catName: {
				required: true,
			},
			discount: {
				required: true,
				digits: true
			},
		},
		messages: {
			catName: {
				required: "Enter category",
			},
			discount: {
				required: "Enter discount",
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Main Category Over
	--------------------------------------*/


	/*--------------------------------------
		Main Category
	--------------------------------------*/
	$("#edit-category").validate({
		rules: {
			catEditId: {
				required: true,
			},
			catEditName: {
				required: true,
			},
			discount: {
				required: true,
				digits: true
			},
		},
		messages: {
			catEditId: {
				required: "",
			},
			catEditName: {
				required: "Enter category",
			},
			discount: {
				required: "Enter discount",
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Main Category Over
	--------------------------------------*/


	/*--------------------------------------
		Sub Category
	--------------------------------------*/
	$(".subCateForm").validate({
		rules: {
			mainCat: {
				required: true,
			},
			subCatName: {
				required: true,
			},
			discount: {
				required: true,
				digits: true
			},
		},
		messages: {
			mainCat: {
				required: "Select main category",
			},
			subCatName: {
				required: "Enter sub category",
			},
			discount: {
				required: "Enter discount",
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Sub Category Over
	--------------------------------------*/


	/*--------------------------------------
		Product
	--------------------------------------*/
	$("#addProForm").validate({
		rules: {
			productName: {
				required: true,
			},
			basePrice: {
				required: true,
				number: true,
			},
			productCode: {
				required: true,
			},
		},
		messages: {
			productName: {
				required: "Enter product name",
			},
			basePrice: {
				required: "Enter Base Price",
				number: "Enter only numbers",
			},
			productCode: {
				required: "Enter Product Code",
			},
		},
	});
	/*--------------------------------------
		Product Over
	--------------------------------------*/
});