$(document).ready(function() {

	var baseUrl = $("#siteBase").text().trim();

	$("#allNav").click(function() {

		 window.location.assign(baseUrl + "products");

		return false;
	});

	$("#" + $("#ePage").text() + " a" ).css("color","#0098db");
	
	$("#userAuth").submit(function() {

		if($("#userAuth").valid()) {

			$(".authBtn").prop('disabled', true);
			$("#userAuth .authSpan img.atuhLoader").remove();
			$("#userAuth .authSpan").append("<img src='"+baseUrl+"assets/img/general/loading.gif' class='atuhLoader'>");

			$.ajax({
				url: baseUrl + "user/auth",
				type: "post",
				data: $("#userAuth").serialize(),
				dataType: "json",
				encod: true
			})
			.done(function(data) {

				if(data.auth) {
					location.reload();
				}
				else if(data.activation) {

					$("#userAuth + span.invalid").remove();
					$("#userAuth").prepend("<b><span class='invalid'>Your email varification is still pendig.</span></b>");
					$(".skey").val(data.token);
				}
				else {
					$("#userAuth + span.invalid").remove();
					$("#userAuth").prepend("<b><span class='invalid'>Invalid email or password</span></b>");
					$(".skey").val(data.token);
				}

				$(".authBtn").prop('disabled', false);
				$("#userAuth .authSpan img.atuhLoader").remove();
			});
		}

		return false;
	});

	$("#userReg").submit(function() {

		if($("#userReg").valid()) {

			$(".regBtn").prop('disabled', true);
			$("#userReg fieldset img.regLoader").remove();
			$("#userReg fieldset").append("<img src='"+baseUrl+"assets/img/general/loading.gif' class='regLoader'>");

			$.ajax({
				url: baseUrl + "user/registration",
				type: "post",
				data: $("#userReg").serialize(),
				dataType: "json",
				encod: true
			})
			.done(function(data) {				

				if(data.email) {
					$("#userReg #emailId + span.invalid").remove();
					$("#userReg #emailId").after("<span class='invalid'>Email alredy existed</span>");
					$("#userReg .skey, #userAuth .skey").val(data.token);
				}
				else if(data.resource) {
					$("#userReg + div.al-danger").remove();
					$("#userReg").prepend("<div class='al-danger'>Something went wrong. Try after some time.</div>");
					$("#userReg .skey, #userAuth .skey").val(data.token);
				}
				else {

					$("#userReg input, #userAuth input").not(".skey").val("");

					$("#userReg #firstName").focus()

					$(".mt-side-widget header p.upMsg").remove();

					$(".mt-side-widget header").prepend("<p class='upMsg'>Your account created successfully. We have sent a link to your Email. Click on that to verify your email.</p>");

					$("#userReg .skey, #userAuth .skey").val(data.token);
				}

				$(".regBtn").prop('disabled', false);
				$("#userReg fieldset img.regLoader").remove();
			});
		}

		return false;
	});

	$("#addToCart").submit(function() {

		if($("#addToCart").valid()) {

			$(".cartBtn").prop('disabled', true);
			$("#addToCart .cartDiv img.cartLoder").remove();
			$("#addToCart .cartDiv").append("<img src='"+baseUrl+"assets/img/general/loading.gif' class='cartLoder'>");

			$.ajax({
				url: baseUrl + "ael/add/to/cart",
				type: "post",
				data: $("#addToCart").serialize(),
				dataType: "json",
				encod: true
			})
			.done(function(data) {

				$(".skey").val(data.token);

				if(data.status) {

					$("#addToCart .cartDiv + span.text-success").remove();

					$("#addToCart .cartDiv").after("<span class='text-success' style='margin:15px;'>Added to cart</span>");
				}
				else if(data.auth) {
					$("body").toggleClass("side-col-active");
					$(".side-opener").toggleClass("active");
					$(".mt-side-over").toggleClass("active");
					$(".mt-side-menu").toggle();
					$(".mt-side-widget header p.upMsg").remove();
					$("#userReg input, #userAuth input").not(".skey").val("");
					$("#userEmail").focus();
				}
				else {
					alert("Something went wrong. Try after some time");
				}

				$(".cartBtn").prop('disabled', false);
				$("#addToCart .cartDiv img.cartLoder").remove();
			});
		}

		return false;
	});

	$(".cart-opener").click(function() {

		$(".cartLi img.cartLoad").remove();
		$(".cartLi").append("<img src='"+baseUrl+"assets/img/general/cart.gif' class='cartLoad'>");

		$.ajax({
			url: baseUrl + "ael/fetch/from/cart",
			type: "get",
			data: $("#addToCart").serialize(),
			dataType: "json",
			encod: true
		})
		.done(function(data) {

			if(data.status) {

				window.location.assign(baseUrl + "mycart");
			}
			else {
				$(".cartLi img.cartLoad").remove();
				$("body").toggleClass("side-col-active");
				$(".side-opener").toggleClass("active");
				$(".mt-side-over").toggleClass("active");
				$(".mt-side-menu").toggle();
				$(".mt-side-widget header p.upMsg").remove();
				$("#userReg input, #userAuth input").not(".skey").val("");
				$("#userEmail").focus();
			}
		});

		return false;
	});

	$("#add-inquiry").submit(function() {

		if($("#add-inquiry").valid()) {

			$.ajax({
				url: baseUrl + "user/inquiry",
				type: "get",
				data: $("#add-inquiry").serialize(),
				dataType: "json",
				encod: true
			})
			.done(function(data) {

				$("#add-inquiry input, #add-inquiry textarea").val("");

				$("#add-inquiry #userName").focus();

				$("#inquiry-wrapper").prepend("<p style='color: #3c763d; background-color: #dff0d8; border-color: #d6e9c6; padding: 15px; border-radius: 4px; font-weight: 500'>We will contact you very soon.</p>");
			});
		}

		return false;
	});

	$("#aelSearch").keyup(function(e) {
		if($(this).val().trim().length > 0 ) {
			if(e.keyCode != 37 && e.keyCode != 38 && e.keyCode != 39 && e.keyCode != 40) {
				$(".ael-search-result .ael-search-loader").show();
				$(".ael-search-result li.result-row, .ael-search-no-record").hide();
				$.ajax({
					url: baseUrl + "product/search",
					type: "get",
					data: {pname: $(this).val().trim()},
					dataType: "json",
					encod: true
				})
				.done(function(data) {
					if(data.list.length > 0) {
						$(".ael-search-result li.result-per").remove();
						var row = "";
						for(var i = 0; i < data.list.length; i++) {
							var nav_link = baseUrl + data.list[i].malias + "/";
							if(data.list[i].salias.length > 0) nav_link += data.list[i].salias + "/";
							nav_link += data.list[i].alias;
							row += "<li class='result-per'><a href='"+nav_link+"'><img src='"+baseUrl+"assets/img/product/"+data.list[i].img_1+"'><span class='pname'>"+data.list[i].pname+"</span> <br><span class='pprice'><i class='fa fa-gbp'></i>"+data.list[i].price+"</span></a></li>";
						}
						$(".ael-search-result").append(row);
					}
					else {
						$(".ael-search-result li.result-per").remove();
						$(".ael-search-result .ael-search-no-record").show();
					}
					$(".ael-search-result .ael-search-loader").hide();
				});
			}
		}
		else {
			$(".ael-search-result li.result-per").remove();
			$(".ael-search-result .ael-search-loader, .ael-search-no-record").hide();
			$(".ael-search-result li.result-row").show();
		}
	});

	$("#app-user-profile-form").submit(function() {

		if($("#app-user-profile-form").valid()) {

			$(".app-user-profile-form-loader").removeClass("app-hide");

			$("#app-user-profile-form .app-error, #app-user-profile-form .app-error").addClass("app-hide");

			$.ajax({
				url: baseUrl + "user/profile/save",
				type: "POST",
				data: $("#app-user-profile-form").serialize(),
				dataType: "json",
				encod: true
			})
			.fail(function() {
				$("#app-user-profile-form .app-error").text("Something went wrong. Try after something").removeClass("app-hide");
				$(".app-user-profile-form-loader").addClass("app-hide");
			})
			.done(function(data) {
				if(data.status == 0) {
					$("#app-user-profile-form .app-msg").text(data.msg).removeClass("app-hide");
					setTimeout(function() {$("#app-user-profile-form .app-msg").addClass("app-hide");}, 3000);
				}
				else if(data.status == 1 && typeof data.error != "undefined") {
					$("#"+Object.keys(data.error)[0]).focus();
					for (var field in data.error) {
						$("#app-user-profile-form #"+field).addClass("app-error").after("<span class='app-error' for='"+data.error[field]+"'>"+data.error[field]+"</span>");
					}
				}
				else {
					$("#app-user-profile-form .app-error").text(data.msg).removeClass("app-hide");
				}
				$(".app-user-profile-form-loader").addClass("app-hide");
				$(".app-token").val(data.token);
			});
		}

		return false;
	});

	$(".proTableDiv table .remove-item").click(function() {
		$(".app-user-cart-loader").addClass("app-hide");
		var parents_tr = $(this).parents("tr");
		var item_id = (typeof parents_tr.attr("data-item-seq") != "undefined") ? parents_tr.attr("data-item-seq") : "";

		var net_total = parseFloat($(".app-user-cart-net-total-val").text().trim());
		var item_price = parseFloat(parents_tr.find("td").eq(4).text().trim());

		if(item_id != "") {
			$.ajax({
				url: baseUrl + "user/cart/remove/item/" + item_id,
				type: "GET",
				dataType: "json",
				encod: true
			})
			.fail(function() {
				$(".app-user-cart-error").text("Something went wrong. Try after something").removeClass("app-hide");
				$(".app-user-cart-loader").addClass("app-hide");
			})
			.done(function(data) {
				if(data.status == 0) {
					var net_total = parseFloat($(".app-user-cart-net-total-val").text().trim());
					var item_price = parseFloat(parents_tr.find("td").eq(4).text().trim());
					var final_total = net_total - item_price;
					parents_tr.remove();
					$(".app-user-cart-net-total-val").text(final_total.toFixed(2));
					$(".app-user-cart-msg").text(data.msg).removeClass("app-hide");
				}
				else {
					$(".app-user-cart-error").text(data.msg).removeClass("app-hide");
				}
				$(".app-user-cart-loader").addClass("app-hide");
			});
		}
	});

	/*$(".cart-checkout").click(function() {
		$.ajax({
			url: baseUrl + "ael/di3ueds23e0r/payment/request",
			type: "GET",
			dataType: "json",
			encod: true
		})
		.fail(function() {
			$(".app-user-cart-error").text("Something went wrong. Try after something").removeClass("app-hide");
			$(".app-user-cart-loader").addClass("app-hide");
		})
		.done(function(data) {
			if(data.status == 0) {
				var net_total = parseFloat($(".app-user-cart-net-total-val").text().trim());
				var item_price = parseFloat(parents_tr.find("td").eq(4).text().trim());
				var final_total = net_total - item_price;
				parents_tr.remove();
				$(".app-user-cart-net-total-val").text(final_total.toFixed(2));
				$(".app-user-cart-msg").text(data.msg).removeClass("app-hide");
			}
			else {
				$(".app-user-cart-error").text(data.msg).removeClass("app-hide");
			}
			$(".app-user-cart-loader").addClass("app-hide");
		});
	});*/
});