<!DOCTYPE html>
<html class="lockscreen" lang="eng">
	<head>
		<meta charset="UTF-8">
		<title>Ecomm - Login</title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/css/bootstrap.min.css')?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/css/font-awesome.min.css')?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/css/AdminLTE.css')?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/css/admin.style.css')?>" />
	</head>
	<body>
		<form id="cherisAuthForm">
			<label class="hide" id="baseValue"><?php echo base_url();?></label>
			<div class="center">
				<div class="headline text-center" id="time"></div>
				<div class="lockscreen-name">Admin Login</div>

				<p class="text-center text-danger hide">Invalid username or passowrd</p>

				<div class="lockscreen-item">
					<div class="lockscreen-credentials">
						<div class="input-group">
							<input type="text" name="userName" id="userName" class="form-control" placeholder="Username" />
						</div>
					</div>
				</div>

				<div class="lockscreen-item">
					<div class="lockscreen-credentials">
						<div class="input-group">
							<input type="password" name="userPass" id="userPass" class="form-control" placeholder="Password" />
						</div>
					</div>
				</div>
				<div class="lockscreen-link">
					<input type="hidden" id="tokeKey" name="<?php echo $cname;?>" value="<?php echo $chash;?>" />
					<div class="authLoader hide">
						<img src="<?php echo base_url('assets/img/general/Rolling.gif') ?>">
					</div>
					<input type="submit" class="btn btn-primary" value="Login" />
				</div>
			</div>
		</form>

		<script src="<?php echo base_url('assets/js/jquery.min.js')?>"></script>
		<script src="<?php echo base_url('assets/js/bootstrap.min.js')?>"></script>
		<script src="<?php echo base_url('assets/js/jquery.validate.js')?>"></script>
		<script src="<?php echo base_url('assets/js/cheris.script.js')?>"></script>
		<script src="<?php echo base_url('assets/js/cheris.validation.js')?>"></script>
		<script>
			$(document).ready(function() {

				var baseUrl = $("#baseValue").text().trim();

				$.fn.startTime = function() {

					$('#time').html(new Date().toLocaleTimeString());

					setTimeout(function() {

						$.fn.startTime();
						
					}, 1000);
				}

				$.fn.center = function() {

					this.css("top", Math.max(0, (($(window).height() - $(this).outerHeight()) / 2) + $(window).scrollTop()) - 70 + "px");

					this.css("left", Math.max(0, (($(window).width() - $(this).outerWidth()) / 2) + $(window).scrollLeft()) + "px");

					return this;
				}

				$.fn.startTime();

				$(".center").center();

				$(window).resize(function() {

					$(".center").center();
				});

				$("#userName").focus();

				$("#cherisAuthForm").submit(function() {

					if($("#cherisAuthForm").valid()) {

						$(".authLoader").show();

						$.ajax({
							url: baseUrl + "ecomm/cheris/auth",
							type: "post",
							data: $("#cherisAuthForm").serialize(),
							dataType: "json",
							encode: true
						})
						.done(function(data) {

							$(".authLoader").hide();

							if(data.status) {
								window.location = baseUrl + "ecomm/patron/category/main";
							}
							else if(data.error.username) {
								$(".lockscreen-item:eq(0) input + span.text-danger").remove();
								$(".lockscreen-item:eq(0) input").after("<span for='userName' class='text-danger'>Invalid username</span>");
								$(".lockscreen-item:eq(0) input").focus();
								$("#tokeKey").val(data.token);
							}
							else if(data.error.pass) {
								$(".lockscreen-item:eq(1) input + span.text-danger").remove();
								$(".lockscreen-item:eq(1) input").after("<span for='userName' class='text-danger'>Invalid password</span>");
								$(".lockscreen-item:eq(1) input").focus();
								$("#tokeKey").val(data.token);
							}
							else {
								window.location = baseUrl + "out";
							}
						});
					}

					return false;
				});
			});
		</script>
	</body>
</html>