<?php

class FrontModel extends CI_Model {

	public function getUserById($user_id)
	{
		return $this->db->get_where("trippers", array("id" => $user_id));
	}

	public function getHomeProduct() {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, mcat.alias as malias, scat.alias as salias, img.img_1")

		->from("product pro")

		->join("category mcat", "pro.cat_id = mcat.id", "INNER")

		->join("sub_category scat", "pro.sub_cat_id = scat.id", "LEFT")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where("pro.status", 1)

		->limit("14")

		->order_by("id", "DESC")

		->get();
	}

	public function getTopSold() {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, mcat.alias as malias, scat.alias as salias, img.img_1")

		->from("product pro")

		->join("category mcat", "pro.cat_id = mcat.id", "INNER")

		->join("sub_category scat", "pro.sub_cat_id = scat.id", "LEFT")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where( array ("pro.status" => 1, "pro.in_top_sold" => 1) )

		->limit("14")

		->order_by("id", "DESC")

		->get();
	}

	public function getAllProducts() {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, mcat.alias as malias, scat.alias as salias, img.img_1")

		->from("product pro")

		->join("category mcat", "pro.cat_id = mcat.id", "INNER")

		->join("sub_category scat", "pro.sub_cat_id = scat.id", "LEFT")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where("pro.status", 1)

		->limit("14")

		->order_by("id", "DESC")

		->get();
	}

	public function checkEmail($email) {

		return $this->db->get_where("trippers", array( "email" => $email ) );
	}

	public function addUser($post, $registration_at, $emailKey) {

		$add_data = array (
			"id" => NULL,
			"first_name" => $post["firstName"],
			"last_name" => $post["lastName"],
			"email" => $post["emailId"],
			"enc_key" => md5($post["passKey"]),
			"registration_at" => $registration_at,
			"email_key" => $emailKey,
			"is_active" => 0
		);

		return $this->db->insert("trippers", $add_data);
	}

	public function checkEmailToEdit($email, $user_id)
	{
		return $this->db->get_where("trippers", array("email" => trim($email), "id !=" => $user_id));
	}

	public function checkMobileToEdit($mobile_number, $user_id)
	{
		return $this->db->get_where("trippers", array("mobile_number" => trim($mobile_number), "id !=" => $user_id));
	}

	public function saveUserProfile($post, $user_id)
	{
		$data = [
			"first_name" => $post["appUserFirstName"],
			"last_name" => $post["appUserLastName"],
			"mobile_number" => $post["appUserMobile"],
			"address" => $post["appUserAddress"],
			"locality" => $post["appUserAddressLocality"],
			"city" => $post["appUserAddressCity"],
			"state" => $post["appUserAddressState"],
			"pin_code" => $post["appUserAddressPincode"],
			"address_type" => $post["appUserAddressType"],
			"email" => $post["appUserEmail"]
		];

		return $this->db->update("trippers", $data, array("id" => $user_id));
	}

	public function getNewUser($post, $registration_at, $emailKey) {

		return $this->db

		->select_max("id")

		->where(array (
			"first_name" => $post["firstName"],
			"last_name" => $post["lastName"],
			"email" => $post["emailId"],
			"enc_key" => md5($post["passKey"]),
			"registration_at" => $registration_at,
			"email_key" => $emailKey,
			"is_active" => 0
		))

		->get("trippers");
	}

	public function checkAuth($post) {

		return $this->db->get_where("trippers", array( "email" => $post["userEmail"], "enc_key" => md5($post["userKey"]) ) );
	}

	public function productInCart($user_id, $product_id) {

		return $this->db->get_where("trippers_cart", array( "user_id" => $user_id, "product_id" => $product_id ) );
	}

	public function incQty( $user_id, $product_id, $qty ) {

		return $this->db

		->where( array ( "user_id" => $user_id, "product_id" => $product_id ) )

		->update( "trippers_cart", array ( "qty" => $qty ) );
	}

	public function addToCart($post, $user_id) {

		$add_data = array (
			"id" => NULL,
			"user_id" => $user_id,
			"product_id" => $post["selProId"],
			"qty" => $post["qty"],
			"status" => 1
		);

		return $this->db->insert("trippers_cart", $add_data);
	}

	public function getCartProducts($user) {

		return $this->db

		->select("cart.id, cart.qty, pro.name, img.img_1, pro.price")

		->from("trippers_cart cart")

		->join("product pro", "cart.product_id = pro.id", "inner")

		->join("product_img img", "pro.id = img.product_id", "inner")

		->where(array("cart.user_id" => $user,"cart.status" => 1))

		->get();
	}

	public function getAllMainCategory() {

		return $this->db->get_where("category", array("status" => 1));
	}

	public function getSubCatByMain($main_cat_id) {

		return $this->db->get_where("sub_category", array("cat_id" => $main_cat_id, "status" => 1));
	}

	public function getCategory() {

		return $this->db->get("category");
	}

	public function setInquiry($post) {

		$add_data = array (
			"id" => NULL,
			"name" => $post["userName"],
			"email" => $post["userEmail"],
			"subject" => $post["userSubject"],
			"message" => $post["userMessage"],
		);

		return $this->db->insert("inquiry", $add_data);
	}

	public function getSubCatProduct($cat_id, $sub_cat_id) {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, img.img_1")

		->from("product pro")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where( array ( "cat_id" => $cat_id, "sub_cat_id" => $sub_cat_id, "status" => 1 ) )

		->limit("14")

		->order_by("id", "DESC")

		->get();
	}

	public function getMainCatProductByAlias($cat_alias, $product_alias) {

		return $this->db

		->select("pro.*, img.*, cat.name AS cat, cat.discount AS cat_discount")

		->from("product pro")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->join("category cat", "pro.cat_id = cat.id", "INNER")

		->where( array( "cat.alias" => trim($cat_alias), "pro.alias" => trim($product_alias) ) )

		->get();
	}

	public function getSubCatProductByAlias($cat_alias, $sub_cat_alias, $product_alias) {

		return $this->db

		->select("pro.*, img.*, cat.name AS cat, sub.name AS subcat, sub.discount AS sub_discount")

		->from("product pro")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->join("category cat", "pro.cat_id = cat.id", "INNER")

		->join("sub_category sub", "pro.sub_cat_id = sub.id", "INNER")

		->where( array( "cat.alias" => trim($cat_alias), "sub.alias" => trim($sub_cat_alias), "pro.alias" => trim($product_alias) ) )

		->get();
	}

	public function getMainCatIdByAlias($alias) {

		return $this->db->get_where("category", array ("status" => 1, "alias" => trim($alias)));
	}

	public function searchMainCatProduct($cat_id) {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, img.img_1")

		->from("product pro")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where(array("pro.status" => 1, "pro.cat_id" => $cat_id))

		->order_by("id", "DESC")

		->get();
	}

	public function getSubCatIdByAlias($cat_alias, $sub_cat_alias) {

		return $this->db

		->select("cat.id AS catid, sub.id AS subid")

		->from("sub_category sub")

		->join("category cat", "sub.cat_id = cat.id", "INNER")

		->where(array("sub.alias" => trim($sub_cat_alias), "sub.status" => 1, "cat.alias" => trim($cat_alias), "cat.status" => 1))

		->get();
	}

	public function searchSubCatProduct($cat_id, $sub_cat_id) {

		return $this->db

		->select("pro.id, pro.name, pro.price, pro.alias, img.img_1")

		->from("product pro")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where(array("pro.status" => 1, "pro.cat_id" => $cat_id, "pro.sub_cat_id" => $sub_cat_id))

		->order_by("id", "DESC")

		->get();
	}

	public function getProdctBySearch($pname) {

		return $this->db

		->select("pro.id, pro.name AS pname, pro.price, pro.alias, mcat.alias as malias, scat.alias as salias, img.img_1")

		->from("product pro")

		->join("category mcat", "pro.cat_id = mcat.id", "INNER")

		->join("sub_category scat", "pro.sub_cat_id = scat.id", "LEFT")

		->join("product_img img", "pro.id = img.product_id", "INNER")

		->where("pro.status", 1)

		->like("pro.name", $pname)

		->order_by("id", "DESC")

		->get();
	}

	public function getCartProductById($item_id)
	{
		return $this->db->get_where("trippers_cart", array("id" => $item_id));
	}

	public function deleteCartProduct($item_id)
	{
		return $this->db->delete("trippers_cart", array("id" => $item_id));
	}

	public function getUserCartDetail($user_id)
	{
		return $this->db->get_where("trippers_cart", array("user_id" => $user_id, "status" => 1));
	}

	public function setUserOrder($order_id, $user_id, $order_detail)
	{
		$data = [
			"order_id" => $order_id,
			"trippers_id" => $user_id,
			"order_details" => $order_detail,
			"order_response_detail" => "",
			"order_status" => 1,
		];

		return $this->db->insert("trippers_orders", $data);
	}

	public function getUserByEmailKey($key)
	{
		return $this->db->get_where("trippers", array("email_key" => $key, "is_active" => 0));
	}

	public function setUserActive($key)
	{
		return $this->db->update("trippers", array("is_active" => 1), array("email_key" => $key));
	}

	public function getOrderByOrderId($order_id)
	{
		return $this->db->get_where("trippers_orders", array("order_id" => $order_id, "order_status" => 1));
	}
}