<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CherishController extends CI_Controller {

	public function attest() {

		$this->session->set_userdata("cherisAuth", true);
		redirect(base_url("ecomm/cheris/auth"));
	}

	public function getAuth() {

		if($this->session->cherisAuth) {

			if($this->session->eauthpnl) {

				redirect(base_url("ecomm/patron/category/main"));
			}
			else {

				$csrf = array (
					'cname' => $this->security->get_csrf_token_name(),
					'chash' => $this->security->get_csrf_hash()
				);

				$this->load->view('cheris/auth', $csrf);
			}
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function authenticate() {

		if($this->input->is_ajax_request()) {

			$this->load->model("CherisModel");
			$mobile_existed = $this->CherisModel->getByUsername($this->input->post("userName"));

			if($mobile_existed->num_rows() == 1) {

				$auth = $this->CherisModel->getAuth($this->input->post("userName"), $this->input->post("userPass"));

				if($auth->num_rows() == 1) {

					$this->session->set_userdata("eauthpnl", true);
					$data["status"] = true;
				}
				else {

					$data["error"]["pass"] = true;
					$data["token"] = $this->security->get_csrf_hash();
				}
			}
			else {

				$data["error"]["username"] = true;
				$data["token"] = $this->security->get_csrf_hash();
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));	
		}
	}

	public function out() {
		
		$this->session->sess_destroy();
		redirect(base_url());
	}
}