$(document).ready(function() {

	var baseUrl = $("#baseValue").text().trim();
	var totalFetched = 10;
	var fetchedImgs = {};
	var scrollFlag = true;
	var changeFalg = fileChange = false;
	var selMainCatRow = subCatli = selEditPro = selDelPro = "";
	var selMainCatId = selSubCatId = totalProducts = basePrice = twentyPer = 0;

	$(".sidebar-menu .product").addClass("active");
	$(".product-col").css("height", $(window).height() - ($(".product-col").offset().top + 20));
	$(window).resize(function() {
		$(".product-col").css("height", $(window).height() - ($(".product-col").offset().top + 20));
	});


	$(".mainCatList li a").click(function() {

		$(".mainCatList + span.text-danger").remove();

		selMainCatRow = $(this);

		if(selMainCatId != selMainCatRow.attr("id")) {

			selMainCatId = selMainCatRow.attr("id");

			selSubCatId = 0;

			$(".mainCatList button span:eq(0)").text($(this).text().trim());

			$(".subCatCol").remove();

			$(".product-col .subCatLoader").show();

			if(selMainCatRow.attr("data-sub") === "YES") {

				$.ajax({
					url: baseUrl + "ecomm/patron/category/sub/fetch",
					type: "get",
					data: {cat_id:selMainCatRow.attr("id")},
					dataType: "json",
					encode: true
				})
				.done(function(data) {

					subCatli = ""

					for (var i = 0; i < data.list.length; i++) {
						
						subCatli += "<li><a id='"+data.list[i].id+"'>"+data.list[i].name+"</a></li>";
					}

					$("<div class='col-lg-3 col-md-3 col-sm-3 col-xs-12 subCatCol'><div class='dropdown subCatList'><button class='btn btn-default dropdown-toggle' type='button' id='dropdownMenu2' data-toggle='dropdown' aria-haspopup=true' aria-expanded='true'><span>Select Sub Category</span><span class='caret'></span></button><ul class='dropdown-menu' aria-labelledby='dropdownMenu2'>"+subCatli+"</ul></div></div>").insertAfter(".product-header .mainCatCol");

					$(".product-col table tbody tr").remove();

					$(".product-col .subCatLoader").hide();
				});
			}
			else {

				$.ajax({
					url: baseUrl + "ecomm/patron/product/fetch",
					type: "get",
					data: {cat_id:selMainCatId, sub_cat_id: selSubCatId, start: 0},
					dataType: "json",
					encode: true
				})
				.done(function(data) {

					$(".product-col table tbody tr").remove();

					totalProducts = data.count;

					totalFetched = 10;

					fetchedImgs = {};

					for (var i = 0; i < data.list.length; i++) {

						fetchedImgs[data.list[i].id] = [];

						fetchedImgs[data.list[i].id][0] = data.list[i].img_1;
						fetchedImgs[data.list[i].id][1] = data.list[i].img_2;
						fetchedImgs[data.list[i].id][2] = data.list[i].img_3;
						fetchedImgs[data.list[i].id][3] = data.list[i].img_4;
						fetchedImgs[data.list[i].id][4] = data.list[i].img_5;
						
						$(".product-table tbody").append("<tr><td class='text-center'><img src='"+baseUrl+"assets/img/product/"+data.list[i].img_1+"'></td><td><span class='product-name'>"+data.list[i].name+"</span><br/><br/><span class='product-code'><b>Code : </b>"+data.list[i].product_code+"</span></td><td>"+data.list[i].sort_description+"</td><td>"+data.list[i].long_description+"</td><td><b>Base Price :</b> <span>"+data.list[i].price+"</span> <br><b>20% TAX :</b> <span>"+( parseInt(data.list[i].price) + (( parseInt(data.list[i].price) * 20) / 100) )+"</span> <br><b>0% TAX :</b> <span>"+data.list[i].price+"</span></td><td>"+(data.list[i].in_top_sold == 1 ? "YES" : "NO")+"</td><td><span class='text-info' id='"+data.list[i].id+"'>EDIT / VIEW</span><br><span class='text-danger' id='"+data.list[i].id+"'>DELETE</span></td></tr>");
					}

					$(".product-col .subCatLoader").hide();
				});
			}
		}
	});

	$("body").on("click", ".subCatList li a", function() {

		selSubCatId = $(this).attr("id");

		$(".subCatList button span:eq(0)").text($(this).text().trim());

		$(".subCatList + span.text-danger").remove();

		$(".product-col .subCatLoader").show();

		$.ajax({
			url: baseUrl + "ecomm/patron/product/fetch",
			type: "get",
			data: {cat_id:selMainCatId, sub_cat_id: selSubCatId, start: 0},
			dataType: "json",
			encode: true
		})
		.done(function(data) {

			$(".product-col table tbody tr").remove();

			totalProducts = data.count;

			totalFetched = 10;

			fetchedImgs = {};

			for (var i = 0; i < data.list.length; i++) {

				fetchedImgs[data.list[i].id] = [];

				fetchedImgs[data.list[i].id][0] = data.list[i].img_1;
				fetchedImgs[data.list[i].id][1] = data.list[i].img_2;
				fetchedImgs[data.list[i].id][2] = data.list[i].img_3;
				fetchedImgs[data.list[i].id][3] = data.list[i].img_4;
				fetchedImgs[data.list[i].id][4] = data.list[i].img_5;

				$(".product-table tbody").append("<tr><td class='text-center'><img src='"+baseUrl+"assets/img/product/"+data.list[i].img_1+"'></td><td><span class='product-name'>"+data.list[i].name+"</span><br/><br/><span class='product-code'><b>Code : </b>"+data.list[i].product_code+"</span></td><td>"+data.list[i].sort_description+"</td><td>"+data.list[i].long_description+"</td><td><b>Base Price :</b> <span>"+data.list[i].price+"</span> <br><b>20% TAX :</b> <span>"+( parseInt(data.list[i].price) + (( parseInt(data.list[i].price) * 20) / 100) )+"</span> <br><b>0% TAX :</b> <span>"+data.list[i].price+"</span></td><td>"+(data.list[i].in_top_sold == 1 ? "YES" : "NO")+"</td><td><span class='text-info' id='"+data.list[i].id+"'>EDIT / VIEW</span><br><span class='text-danger' id='"+data.list[i].id+"'>DELETE</span></td></tr>");
			}

			$(".product-col .subCatLoader").hide();
		});
	});

	$(".product-add").click(function() {

		if(selMainCatId == 0) {

			$(".mainCatCol span.text-danger").remove();

			$(".mainCatCol").append("<span class='text-danger' style='font-size:14px;'>Sele main category</span>");
		}
		else if($(".mainCatList li a#" + selMainCatId).attr("data-sub") == "YES" && selSubCatId == 0) {

			$(".subCatList + span.text-danger").remove();

			$(".subCatCol").append("<span class='text-danger' style='font-size:14px;'>Sele sub category</span>");
		}
		else {

			$(".product-modal input[type='text'], .product-modal input[type='file'], .product-modal textarea").val("");

			$(".product-modal #tax-20, .product-modal #tax-0").text("");

			$(".product-modal input[type='checkbox']").prop("checked", false);

			$(".product-modal span.text-danger").remove();

			$(".product-modal ul li img").attr("src", baseUrl + "assets/img/general/product.png");

			$(".product-modal form").hide();

			$(".product-modal #addProForm").show();

			$(".product-modal .modal-header h4.modal-title").text("Add Product");

			$(".product-modal .subCatLoader").hide();

			$(".product-modal").modal("show");
		}
	});

	$(".product-modal").on("shown.bs.modal", function () {

		if($(".product-modal #addProForm").css("display") == "block") {

			$("#productName").focus();
		}
		else {

			$("#editProForm #productName").focus();
		}
	});

	$(".cbp").keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
             // Allow: Ctrl/cmd+A
            (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
             // Allow: Ctrl/cmd+C
            (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
             // Allow: Ctrl/cmd+X
            (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
             // Allow: home, end, left, right
            (e.keyCode >= 35 && e.keyCode <= 39)) {
                 // let it happen, don't do anything
                 return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });

    $(".cbp").keyup(function (e) {

    	if($(this).val().length > 0) {

    		twentyPer = parseFloat($(this).val().trim());

    		twentyPer += ((twentyPer * 20) / 100);

    		$(".tax-20").text( twentyPer.toFixed(2) );

    		$(".tax-0").text($(this).val());
    	}
    	else {

    		$(".tax-20").text("");

    		$(".tax-0").text("");
    	}
    });

	$(".product-modal .modal-body ul li button").click(function() {

		$(this).parents("li").find("input[type='file']").trigger("click");
	});

	$(".product-modal .modal-body ul li input[type='file']").change(function() {

		var tmpImg = $(this);

		if (this.files && this.files[0]) {

			fileChange = true;

			if($("#productImg1").val().trim().length > 4) {

				$("#addProForm .img-msg + span.text-danger").remove();
			}

			var reader = new FileReader();

			reader.onload = function (e) {
				tmpImg.parents("li").find("img").attr("src", e.target.result);
			}

			reader.readAsDataURL(this.files[0]);
		}
	});

	$.fn.checkMainImg = function() {
		if($("#productImg1").val().trim().length > 4) {

			return true;
		}
		else {

			$("#addProForm .img-msg + span.text-danger").remove();

			$("#addProForm .img-msg").after("<span class='text-danger' style='font-size:14px;'>Select main image</span>");

			return false;
		}
	}

	$("#addProForm").submit(function() {

		if($.fn.checkMainImg() && $("#addProForm").valid()) {

			$(".product-modal .subCatLoader").show();

			$("#addProForm").append("<input type='hidden' name='cat_id' value='"+selMainCatId+"'>");

			$("#addProForm").append("<input type='hidden' name='sub_cat_id' value='"+selSubCatId+"'>");

			$.ajax({
				url: baseUrl + "ecomm/patron/product/add",
				type: "post",
				data: new FormData(document.getElementById("addProForm")),
				dataType: "json",
				processData: false,
				contentType: false,
				encode: true
			})
			.done(function(data) {

				fetchedImgs[data.id] = [];

				fetchedImgs[data.id][0] = data.imgs[0];
				fetchedImgs[data.id][1] = data.imgs[1];
				fetchedImgs[data.id][2] = data.imgs[2];
				fetchedImgs[data.id][3] = data.imgs[3];
				fetchedImgs[data.id][4] = data.imgs[4];

				
				$(".product-table tbody").prepend("<tr><td class='text-center'><img src='"+baseUrl+"assets/img/product/"+data.first+"'></td><td><span class='product-name'>"+$("#addProForm #productName").val().trim()+"</span><br/><br/><span class='product-code'><b>Code : </b>"+$("#addProForm #productCode").val().trim()+"</span></td><td>"+$("#addProForm #sortDescription").val().trim()+"</td><td>"+$("#addProForm #longDescription").val().trim()+"</td><td><b>Base Price :</b> <span>"+$("#addProForm #basePrice").val()+"</span> <br><b>20% TAX :</b> <span>"+( parseInt($("#addProForm #basePrice").val()) + ((parseInt($("#addProForm #basePrice").val()) * 20) / 100)) + "</span><br><b>0% TAX :</b> <span>"+$("#addProForm #basePrice").val()+"</span></td> <td>"+ ($("#addProForm #topSold").prop("checked") ? "YES" : "NO") +"</td> <td><span class='text-info' id='"+data.id+"'>EDIT / VIEW</span><br><span class='text-danger' id='"+data.id+"'>DELETE</span></td></tr>");


				$(".product-modal input[type='text'], .product-modal input[type='file'], .product-modal textarea").val("");

				$(".product-modal #tax-20, .product-modal #tax-0").text("");

				$(".product-modal input[type='checkbox']").prop("checked", false);

				$(".product-modal ul li img").attr("src", baseUrl + "assets/img/general/product.png");

				$("#addProForm #productName").focus();

				$(".product-modal .modal-body div.alert-success").remove();

				$(".product-modal .modal-body").prepend("<div class='alert alert-success'>Product added successfully</div>");

				setTimeout(function() {
					$(".product-modal .modal-body div.alert-success").remove();
				}, 2500);

				$(".product-modal .subCatLoader").hide();
			});
		}

		return false;
	});

	$(".product-col").scroll(function() {

		$(".proLoader").css("bottom", 0);
		
		if(totalFetched < totalProducts  && $(".product-col").scrollTop() >= ((document.getElementById("productCompo").scrollHeight - document.getElementById("productCompo").clientHeight) - 100 ) && scrollFlag ) {

			scrollFlag = false;

			$(".proLoader").show();

			$.ajax({
				url: baseUrl + "ecomm/patron/product/fetch",
				type: "get",
				data: {cat_id:selMainCatId, sub_cat_id: selSubCatId, start: totalFetched},
				dataType: "json",
				encode: true
			})
			.done(function(data) {

				totalFetched += 10;

				for (var i = 0; i < data.list.length; i++) {

					fetchedImgs[data.list[i].id] = [];

					fetchedImgs[data.list[i].id][0] = data.list[i].img_1;
					fetchedImgs[data.list[i].id][1] = data.list[i].img_2;
					fetchedImgs[data.list[i].id][2] = data.list[i].img_3;
					fetchedImgs[data.list[i].id][3] = data.list[i].img_4;
					fetchedImgs[data.list[i].id][4] = data.list[i].img_5;
					
					$(".product-table tbody").append("<tr><td class='text-center'><img src='"+baseUrl+"assets/img/product/"+data.list[i].img_1+"'></td><td>"+data.list[i].name+"</td><td><b>Inc VAT :</b> <span>"+data.list[i].inc_price+"</span> <br><b>Exc VAT :</b> <span>"+data.list[i].exc_price+"</span> <br><b>Offer :</b> <span>"+data.list[i].offer_price+"</span></td><td><span class='text-info' id='"+data.list[i].id+"'>EDIT / VIEW</span><br><span class='text-danger' id='"+data.list[i].id+"'>DELETE</span></td></tr>");
				}

				$(".proLoader").hide();

				scrollFlag = true;
			});
		}
	});

	$("body").on("click", ".product-table tbody tr td span.text-info", function() {

		selEditPro = $(this);

		basePrice = parseInt(selEditPro.parents("tr").find("td:eq(4) span:eq(1)").text().trim());

		$(".product-modal .modal-header h4.modal-title").text("Edit Product");

		$("#editProForm span.text-danger").remove();

		$("#editProForm #productName").val(selEditPro.parents("tr").find("td:eq(1) span.product-name").text().trim());

		$("#editProForm #basePrice").val(basePrice);

		$("#editProForm #tax-20").text(basePrice + (( basePrice * 20) / 100));

		$("#editProForm #tax-0").text(basePrice);

		$("#editProForm #sortDescription").val(selEditPro.parents("tr").find("td:eq(2)").text().trim());

		$("#editProForm #longDescription").val(selEditPro.parents("tr").find("td:eq(3)").text().trim());

		$("#editProForm #productCode").val( selEditPro.parents("tr").find("td:eq(1) span.product-code").text().trim().replace(/[^\d.]/g, ''));

		$("#editProForm #topSold").prop("checked", selEditPro.parents("tr").find("td:eq(5)").text().trim() == "YES" ? true : false);

		$(".product-modal ul li img").attr("src", baseUrl + "assets/img/general/product.png");

		$("#editProForm ul li:eq(0) img").attr("src", baseUrl + "assets/img/product/" + fetchedImgs[selEditPro.attr("id")][0]);

		if(fetchedImgs[selEditPro.attr("id")][1] !== "") {
			$("#editProForm ul li:eq(1) img").attr("src", baseUrl + "assets/img/product/" + fetchedImgs[selEditPro.attr("id")][1]);
		}

		if(fetchedImgs[selEditPro.attr("id")][2] !== "") {
			$("#editProForm ul li:eq(2) img").attr("src", baseUrl + "assets/img/product/" + fetchedImgs[selEditPro.attr("id")][2]);
		}

		if(fetchedImgs[selEditPro.attr("id")][3] !== "") {
			$("#editProForm ul li:eq(3) img").attr("src", baseUrl + "assets/img/product/" + fetchedImgs[selEditPro.attr("id")][3]);
		}

		if(fetchedImgs[selEditPro.attr("id")][4] !== "") {
			$("#editProForm ul li:eq(4) img").attr("src", baseUrl + "assets/img/product/" + fetchedImgs[selEditPro.attr("id")][4]);
		}

		$(".product-modal form").hide();

		$(".product-modal #editProForm").show();

		$(".product-modal .subCatLoader").hide();

		$(".product-modal").modal("show");
	});

	$("#editProForm").submit(function() {

		$(".product-modal .subCatLoader").show();

		$("#editProForm").append("<input type='hidden' name='cat_id' value='"+selMainCatId+"'>");

		$("#editProForm").append("<input type='hidden' name='sub_cat_id' value='"+selSubCatId+"'>");

		$("#editProForm").append("<input type='hidden' name='pro_id' value='"+selEditPro.attr("id")+"'>");

		if($("#editProForm #productName").val().trim() !== selEditPro.parents("tr").find("td:eq(1)").text().trim()) {

			changeFalg = true;
		}
		else if($("#editProForm #basePrice").val().trim() !== selEditPro.parents("tr").find("td:eq(2) span:eq(0)").text().trim()) {

			changeFalg = true;
		}
		else if(fileChange) {

			changeFalg = true;	
		}
		
		if(changeFalg) {

			changeFalg = false;

			$.ajax({
				url: baseUrl + "ecomm/patron/product/edit",
				type: "post",
				data: new FormData(document.getElementById("editProForm")),
				dataType: "json",
				processData: false,
				contentType: false,
				encode: true
			})
			.done(function(data) {

				selEditPro.parents("tr").find("td:eq(1)").html("").html("<span class='product-name'>"+$("#editProForm #productName").val().trim() + "</span><br/><br/><span><b>Code : </b>"+$("#editProForm #productCode").val().trim()+"</span>");

				selEditPro.parents("tr").find("td:eq(2)").text($("#editProForm #sortDescription").val().trim());

				selEditPro.parents("tr").find("td:eq(3)").text($("#editProForm #longDescription").val().trim());

				selEditPro.parents("tr").find("td:eq(4) span:eq(0)").text($("#editProForm #basePrice").val().trim());

				selEditPro.parents("tr").find("td:eq(4) span:eq(1)").text($("#editProForm #tax-20").text().trim());

				selEditPro.parents("tr").find("td:eq(4) span:eq(2)").text($("#editProForm #basePrice").val().trim());

				selEditPro.parents("tr").find("td:eq(5)").text(($("#editProForm #topSold").prop("checked") ? "YES" : "NO"));

				if(typeof data.imgs !== 'undefined') {

					if(typeof data.imgs.img_1 !== 'undefined') {

						selEditPro.parents("tr").find("td:eq(0) img").attr("src", baseUrl + "assets/img/product/" + data.imgs.img_1);
					}

					$.each(data.imgs, function(key, value) {

						fetchedImgs[selEditPro.attr("id")][parseInt(key.substr(key.length - 1)) -1] = value;
					});
				}

				$(".product-modal").modal("hide");

				fileChange = false;
			});
		}
		else {
			$(".product-modal").modal("hide");
		}

		return false;
	});

	$("body").on("click", ".product-table tbody tr td span.text-danger", function() {

		selDelPro = $(this);

		$.ajax({
			url: baseUrl + "ecomm/patron/product/delete",
			type: "get",
			data: {pro_id: selDelPro.attr("id")},
			dataType: "json",
			encode: true
		})
		.done(function(data) {

			delete fetchedImgs[selDelPro.attr("id")];

			selDelPro.parents("tr").remove();
		});
	});
});