<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PatronController extends CI_Controller {

	public function __construct() {

		parent::__construct();

		if(!$this->session->cherisAuth || !$this->session->eauthpnl) {

			redirect(base_url("out"));
		}
	}

	public function fetchMainCategory() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getMainCategoryForList()->result();

		$data["jsFile"] = "category_main";

		$data["page"] = "cheris/category_main";

		$this->load->view("layout/patron", $data);
	}

	public function addMainCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$alias = $this->clean(trim($this->input->get("catName")));

			$alias_existed = $this->PatronModel->checkMainCatAliasForAdd($alias);

			if($alias_existed->num_rows() > 0 ) {

				$data["existed"] = true;
			}
			else {

				$data["id"] = $this->PatronModel->addMainCategory($this->input->get(), $alias)->row()->id;
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function editMainCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$alias = $this->clean(trim($this->input->get("catName")));

			$alias_existed = $this->PatronModel->getMainCatAliasForEdit($this->input->get("catId"), $alias);

			if($alias_existed->num_rows() > 0 ) {

				$data["existed"] = true;
			}
			else {

				$this->PatronModel->editMainCategory($this->input->get(), $alias);

				$data["status"] = true;
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function deleteMainCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$this->PatronModel->deleteMainCategory($this->input->get("id"));

			$data["status"] = true;

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function fetchMainCategoryForSubCategory() {

		$li = ""; $opt = "";

		$this->load->model("PatronModel");

		$list = $this->PatronModel->getMainCategoryForSub()->result();

		foreach ($list as $row) {

			$li .= "<li><a id='".$row->id."'>".$row->name."</a></li>";

			$opt .= "<option value='".$row->id."'>".$row->name."</option>";
		}

		$data["li"] = $li;

		$data["opt"] = $opt;

		$data["jsFile"] = "category_sub";

		$data["page"] = "cheris/category_sub";

		$this->load->view("layout/patron", $data);
	}

	public function fetchSubCategory() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getSubCategory($this->input->get("cat_id"))->result();

		echo json_encode($data);
	}

	public function addSubCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$alias = $this->clean(trim($this->input->get("subCatName")));

			$alias_existed = $this->PatronModel->checkSubCatAliasForAdd($alias);

			if($alias_existed->num_rows() > 0) {

				$data["existed"] = true;
			}
			else {

				$data["id"] = $this->PatronModel->addSubCategory($this->input->get(), $alias)->row()->id;
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function editSubCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$alias = $this->clean(trim($this->input->get("editSubCatName")));

			$alias_existed = $this->PatronModel->checkSubCatAliasForEdit($this->input->get("catId"), $alias);

			if($alias_existed->num_rows() > 0 ) {

				$data["existed"] = true;
			}
			else {
				
				$this->PatronModel->editSubCategory($this->input->get(), $alias);

				$data["status"] = true;
			}

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function deleteSubCategory() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$this->PatronModel->deleteSubCategory($this->input->get("id"));

			$data["status"] = true;

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function productView() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getMainCategory()->result();

		$data["jsFile"] = "patron_product";

		$data["page"] = "cheris/product";

		$this->load->view("layout/patron", $data);
	}

	public function fetchProduct() {

		$this->load->model("PatronModel");

		$data["count"] = $this->PatronModel->getProductCount($this->input->get("cat_id"), $this->input->get("sub_cat_id"));

		$data["list"] = $this->PatronModel->getProducts($this->input->get("cat_id"), $this->input->get("sub_cat_id"), $this->input->get("start"))->result();

		echo json_encode($data);
	}

	public function addProduct() {

		if($this->input->is_ajax_request()) {

			$nConfig["upload_path"] = "./assets/img/product/";
			$nConfig["allowed_types"] = "gif|jpg|png|jpeg";
			$nConfig["max_size"]	= "2048";
			$this->load->library('upload');
			$imgsName = array ();

			for ($i = 1; $i <= 5; $i++) {
				
				if($_FILES["productImg$i"]["name"] != "") {

					$nTemp = explode(".", $_FILES["productImg$i"]["name"]);

					$nExtension = end($nTemp);

					$img = md5(date("l, F d, Y h:i" ,time()) . (microtime()) . $_FILES["productImg$i"]["name"]) . "." . $nExtension;

					$nConfig["file_name"] = $img;

					$this->upload->initialize($nConfig);

					$this->upload->do_upload("productImg$i");

					$imgsName[] = $img;
				}
				else {

					$imgsName[] = "";
				}
			}

			$this->load->helper('string');

			$this->load->model("PatronModel");

			$alias = $this->clean(trim($this->input->post("productName")));

			$alias_existed = $this->PatronModel->getProductAliasForAdd($alias)->row()->ttl;

			if($alias_existed > 0 ) {

				if( $alias_existed == 1 ) {

					$alias = $alias . "-1";
				}
				else {

					$alias = $alias . "-" . intval( intval($alias_existed) + 1);
				}
			}

			$data["id"] = $this->PatronModel->addProduct($this->input->post(), $imgsName, $alias);

			$data["first"] = $imgsName[0];

			$data["imgs"] = $imgsName;

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function editProduct() {

		if($this->input->is_ajax_request()) {

			$nConfig["upload_path"] = "./assets/img/product/";
			$nConfig["allowed_types"] = "gif|jpg|png|jpeg";
			$nConfig["max_size"]	= "2048";
			$this->load->library('upload');
			$imgsName = array ();

			for ($i = 1; $i <= 5; $i++) {
				
				if($_FILES["editProductImg$i"]["name"] != "") {

					$nTemp = explode(".", $_FILES["editProductImg$i"]["name"]);

					$nExtension = end($nTemp);

					$img = md5(date("l, F d, Y h:i" ,time()) . (microtime()) . $_FILES["editProductImg$i"]["name"]) . "." . $nExtension;

					$nConfig["file_name"] = $img;

					$this->upload->initialize($nConfig);

					$this->upload->do_upload("editProductImg$i");

					$imgsName["img_$i"] = $img;
				}
			}

			$this->load->model("PatronModel");			

			$alias = $this->clean(trim($this->input->post("productName")));

			$alias_existed = $this->PatronModel->getProductAliasForEdit($this->input->post("pro_id"), $alias)->row()->ttl;

			if($alias_existed > 0 ) {

				if( $alias_existed == 1 ) {

					$alias = $alias . "-1";
				}
				else {

					$alias = $alias . "-" . intval( intval($alias_existed) + 1);
				}
			}

			$this->PatronModel->editProduct($this->input->post(), $imgsName, $alias);

			if(count($imgsName) > 0) {

				$data["imgs"] = $imgsName;
			}

			$data["status"] = true;

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function deleteProduct() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$this->PatronModel->deleteProduct($this->input->get("pro_id"));

			$data["status"] = true;

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}
	}

	public function fetchTopProduct() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getTopProducts()->result();

		$data["jsFile"] = "features";

		$data["page"] = "cheris/top_products";

		$this->load->view("layout/patron", $data);
	}

	public function deleteTopProduct() {

		if($this->input->is_ajax_request()) {

			$this->load->model("PatronModel");

			$data["status"] = $this->PatronModel->deleteTopProduct($this->input->get("id"));

			echo json_encode($data);
		}
		else {

			redirect(base_url("out"));
		}		
	}

	public function allUser() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getUser()->result();

		$data["jsFile"] = "features";

		$data["page"] = "cheris/users";

		$this->load->view("layout/patron", $data);
	}

	public function allUserCart() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getCart()->result();

		$data["jsFile"] = "features";

		$data["page"] = "cheris/cart";

		$this->load->view("layout/patron", $data);
	}

	public function allInquiry() {

		$this->load->model("PatronModel");

		$data["list"] = $this->PatronModel->getInquiry()->result();

		$data["jsFile"] = "features";

		$data["page"] = "cheris/inquiry";

		$this->load->view("layout/patron", $data);
	}

	public function clean($string) {

		$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $string);

		$clean = preg_replace("!\s+!", "-", strtolower($clean));

		$clean = preg_replace('/[^a-zA-Z0-9]+/', '-', $clean);

		$clean = preg_replace('/-{2,}/','-', $clean);

		return trim($clean, "-");
	}

	public function manageAlias($current, $new) {

		if(ctype_digit(substr($current, -1))) {

			$alias_current_num =  substr($current, (strrpos($current, "-") + 1), strlen($current));

			$alias = $new . "-" . intval($alias_current_num + 1);
		}
		else {
			$alias = $new . "-1";
		}

		return $alias;
	}
}