$(document).ready(function() {

	$.validator.setDefaults({
		ignore: [],
		errorElement: "span",
		errorClass: "app-error",
		validClass: "app-valid",
		errorPlacement: function(error, element) {
			var placement = $(element).data('error');
			if (placement) {
				$(placement).append(error)
			}
			else {
				error.insertAfter(element);
			}
		}
	});

	jQuery.validator.addMethod("accept", function(value, element, param) {

		return value.match(new RegExp("^" + param + "$"));
	});

	$.validator.addMethod("aplhaOnly", function(value, event) {
		if(/^[a-zA-Z]*$/.test(value) == false) {
			return false;
		}

		return true;
	});

	/*--------------------------------------
		User Auth
	--------------------------------------*/
	$("#userAuth").validate({
		onfocusout: false,
		rules: {
			userEmail: {
				required: true,
				email: true
			},
			userKey: {
				required: true,
				minlength: 6,
			},
		},
		messages: {
			userEmail:{
				required: "Enter email",
				email: "Invalid email"
			},
			userKey: {
				required: "Enter password",
				minlength: "Minimum 6 letters required",
			},
		},
	});
	/*--------------------------------------
		User Auth Over
	--------------------------------------*/


	/*--------------------------------------
		User Regi
	--------------------------------------*/
	$("#userReg").validate({
		onfocusout: false,
		rules: {
			firstName: {
				required: true,
				accept: "[a-zA-Z]+",
			},
			lastName: {
				required: true,
				accept: "[a-zA-Z]+",
			},
			emailId: {
				required: true,
				email: true
			},
			passKey: {
				required: true,
				minlength: 6,
			},
		},
		messages: {
			firstName: {
				required: "Enter first name",
				accept: "Invalid first name",
			},
			lastName: {
				required: "Enter last name",
				accept: "Invalid last name",
			},
			emailId: {
				required: "Enter email",
				email: "Invalid email"
			},
			passKey: {
				required: "Enter password",
				minlength: "Minimum 6 letters required",
			},
		},
	});
	/*--------------------------------------
		User Regi Over
	--------------------------------------*/


	/*--------------------------------------
		Cart
	--------------------------------------*/
	$("#addToCart").validate({
		onfocusout: false,
		rules: {
			qty: {
				required: true,
				digits: true
			},
		},
		messages: {
			qty:{
				required: "Enter quantity",
				digits: "Enter only digits"
			},
		},
	});
	/*--------------------------------------
		Cart Over
	--------------------------------------*/


	/*--------------------------------------
		User Auth
	--------------------------------------*/
	$("#add-inquiry").validate({
		onfocusout: false,
		rules: {
			userName: {
				required: true,
			},
			userEmail: {
				required: true,
				email: true,
			},
			userSubject: {
				required: true,
			},
			userMessage: {
				required: true,
			},
		},
		messages: {
			userName: {
				required: "Enter your name",
			},
			userEmail: {
				required: "Enter your email",
				email: "Invalid email",
			},
			userSubject: {
				required: "Enter subject",
			},
			userMessage: {
				required: "Enter messages",
			},
		},
	});
	/*--------------------------------------
		User Auth Over
	--------------------------------------*/

	$("#app-user-profile-form").validate({
		onfocusout: false,
		rules: {
			appUserFirstName: {
				required: true,
				aplhaOnly: true,
			},
			appUserLastName: {
				required: true,
				aplhaOnly: true,
			},
			appUserEmail: {
				required: true,
				email: true,
			},
			appUserMobile: {
				required: true,
				digits: true,
				maxlength: 15,
			},
			appUserAddress: {
				required: true,
			},
			appUserAddressLocality: {
				required: true,
			},
			appUserAddressCity: {
				required: true,
			},
			appUserAddressState: {
				required: true,
			},
			appUserAddressPincode: {
				required: true,
				digits: true
			},
		},
		messages: {
			appUserFirstName: {
				required: "Enter first name",
				aplhaOnly: "Invalid first name. Allowed only a-z",
			},
			appUserLastName: {
				required: "Enter last name",
				aplhaOnly: "Invalid last name. Allowed only a-z",
			},
			appUserEmail: {
				required: "Enter email address",
				email: "Invalid email address",
			},
			appUserMobile: {
				required: "Enter mobile number",
				digits: "Invalid mobile number. Allowed only 0-9",
				maxlength: "Mobile number maximum 15 digit long",
			},
			appUserAddress: {
				required: "Enter address",
			},
			appUserAddressLocality: {
				required: "Enter locality",
			},
			appUserAddressCity: {
				required: "Enter city",
			},
			appUserAddressState: {
				required: "Enter state",
			},
			appUserAddressPincode: {
				required: "Enter pin code",
				digits: "Invalid pin code. Allowed only digits",
			},
		},
	});
});